<?php
//---------------------------------------------------------------------------------------------------------
// 01/Febrero/2019 ==> Aquí se ejecutan las acciones asociadas a este módulo
//---------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------
// Códigos de error:
//	 0 ==> Error sin especificar
//	-1 ==> Usuario ya exsistente
//	-2 ==> Los passwords no coinciden
//	-3 ==> El password introducido no cumple con la norma estabelcida (al menos 6 caracteres, letras y números y una mayúscula y una minúscula
//	-4 ==> Falta por rellenar algún dato
//---------------------------------------------------------------------------------------------------------

	//Este fichero va a hacer lo siguiente:
	//Si un cliente se registra, intentamos hacer el registro en la BD. Según el resultado así devolvemos la info al usuario
	//Para ello utilizamos la sesión y ahí almacenamos el resultado de un registro
	//Hay que tener en cuenta que cuando un usuario se registra hacemos una recarga de la web para asegurarnos de que no haya problemas con el F5
	//Empezamos intentando coger los datos del formulario:
	//$accion = Getter::get('accion', NULL);
	
	//Estructura dónde almacenaremos los datos del usuario para que se mantengan al recargar la sesión:
	$datos_usuario_registro = array();
	//Si hemos recibido un "redirigir_a" lo guardamos en la sesión:

	//Si alguno de estos parámetros no es NULL, pasamos a la verificación de datos, siempre y cuando la acción actual sea 'registro':
	function register_registro(){
		$estado_registro = NULL;
		$email_usuario = Getter::get('email', NULL);
		$nombre_usuario = Getter::get('nombre', NULL);
		$password_usuario = Getter::get('password', NULL);
		$password_repetido = Getter::get('password_repetido', NULL);
		//Pedro 06/Agosto/2020 ==> Vamos a recoger si el cliente acepta recibir publicidad. El nombre del campo ya estaba en la plantilla así que no lo cambiamos para no tener que cambiar también la plantilla
		$pPupliSi = Getter::get('pPupliSi', NULL);
		//Vamos a utilizar una variable que indica a donde redirigir en caso de éxito
		$redirigir_a = Getter::get('redirigir_a', NULL);
		
		if ( ( ($email_usuario != NULL) || ($nombre_usuario != NULL) || ($password_usuario != NULL) || ($password_repetido != NULL)) ){
			//Si algún dato es incorrecto, entonces devolvemos YA un -4
			if ( ($email_usuario == NULL) || ($nombre_usuario == NULL) || ($password_usuario == NULL) || ($password_repetido == NULL) || ($email_usuario == ' ') || ($nombre_usuario == ' ') || ($password_usuario == ' ') || ($password_repetido == ' ')){
				$estado_registro = -4;
			}
			//Si el estado de registro aún es nulo, todo va bien:
			if ($estado_registro == NULL){
				//Validamos el email:
				if (Usuario::exists($email_usuario)){
					$estado_registro = -1;
				}
			}
			if ($estado_registro == NULL){
				//Los passwords han de ser exactamente iguales:
				if ($password_usuario != $password_repetido){
					$estado_registro = -2;
				}
			}
			//El password tiene que tener caracteres ==> números y letras, maýusculas y minúsculas
			if ($estado_registro == NULL){
				if ( !(preg_match('/[A-Za-z].*[0-9]|[0-9].*[A-Za-z]/', $password_usuario)) ){
					$estado_registro = -3;
				}
			}
			if ($estado_registro == NULL){
				//Si el estado de registro sigue siendo nulo, vamos a registrar al cliente:
				$datos_cliente = array(
					'nombre_comercial' => $nombre_usuario,
					'nombre_legal' => $nombre_usuario,
					'email' => $email_usuario,
					'password' => $password_usuario,
					'pendiente_sinlib' => 1
				);
				//06/Agosto/2020 ==> Añadimos el campo de la publicidad:
				if ($pPupliSi != NULL){
					$datos_cliente['condiciones_aceptadas'] = 1;
				}
				//A la hora de registrar a un cliente vamos a tener en cuenta si el registro requiere o no confirmación
				if (!Shop::$configuracion->registro_con_confirmacion){
					$datos_cliente['codigo_confirmacion'] = '0';
				}
				//Álvaro 080219 TAREA 5187 WEBSTORE: Plantillas de emails. Modificamos el código para funcionar con todo el objeto cliente y enviarlo a la plantilla.
				$cliente = Usuario::register($datos_cliente);
				$estado_registro = $cliente->codigo;
				if ($estado_registro != ''){
					Sesion::remove('datos_usuario_registro');
					//Según el resultado vamos a loguear ya directamente al usuario o no:
					$fichero_email = 'email_codigo_confirmacion_registro.php';
					if (Shop::$configuracion->registro_con_confirmacion){
						$estado_registro =  -5;
						//la dirección de destino así como el nombre lo vamos a coger de los datos recibidos
							//$email_usuario
							//$nombre_usuario
						//Álvaro 060219 TAREA 5177 WEBSTORE: Dentro de la carpeta "modules" estamos preparando los módulos que se podrán instalar/desinstalar de webStore.
						Email::sendMail(new OpcionesWidget(array(
									'destinatario' => $datos_cliente['email'] . ',' . $datos_cliente['nombre_comercial'], 
									'asunto' => 'Confirmación de registro en la web ' . Shop::$empresa->nombre . '(' . Shop::$configuracion->url . ')', 
									'contenido' => $cliente,
									'templateFile' => $fichero_email)));
						
					}else{
						//Hay que enviar un email al usuario dándole las gracias por el registro
						$fichero_email = 'email_registro.php';
						//Aquí añadimos la nueva función de login
						//Usuario::login($datos_cliente['email'], $datos_cliente['password']);
						$cliente->logme();
						//Enviamos un email al usuario utilizando la plantilla especificada y cogiendo el destinatario y su nombre del cliente de la sesión (se ha hecho login)
						//No es necesario espeficiar más contenido
						//Álvaro 060219 TAREA 5177 WEBSTORE: Dentro de la carpeta "modules" estamos preparando los módulos que se podrán instalar/desinstalar de webStore.
						$logueado = Usuario::logueado();
						Email::sendMail(new OpcionesWidget(array(
									'destinatario' => $logueado->email . ',' . $logueado->nombre_comercial, 
									'asunto' => 'Gracias por registrarse en la web ' . Shop::$empresa->nombre . '( ' . Shop::$configuracion->url . ' )', 
									'contenido' => $cliente,
									'templateFile' => $fichero_email)));
					}
					
					
					//Si hay que redirigir a los usuarios, lo hacemos
					if ($redirigir_a != NULL){
						//Redirigimos desde la sesión para que se haga el "commit" actual
						Sesion::reloadPage(Shop::$configuracion->url . $redirigir_a);
					}
				}
			}
			//Llegados a este punto, si el estado de registro es menor o igual que 0, es que ha habido un error
			if ($estado_registro <= 0){
				Sesion::set('estado_registro', $estado_registro);
				$datos_usuario_registro = array(
					'email_usuario' => $email_usuario,
					'nombre_usuario' => $nombre_usuario,
				);
				Sesion::set('datos_usuario_registro', $datos_usuario_registro);
			}else{
				//En caso contrario, nos aseguramos de eliminar de la sesión el estado del registro:
				Sesion::remove('estado_registro');
				Sesion::remove('datos_usuario_registro');
			}
			//Recargamos la página
			Sesion::setReloadPage(Sesion::getReloadPage() | true);
		}else{
			//Si hay error, no hay que hacer nada, ya lo hace la web sola
		}
	}
	
	//Pedro 02/Abril/2019 ==> Controlamos el registro sin password:
	function register_registro_sin_password(){
		$estado_registro = NULL;
		$email_usuario = Getter::get('email', NULL);
		$nombre_usuario = Getter::get('nombre', NULL);

		//Vamos a utilizar una variable que indica a donde redirigir en caso de éxito
		$redirigir_a = Getter::get('redirigir_a', NULL);

		if ( ($email_usuario != NULL) || ($nombre_usuario != NULL) ){
			//Si algún dato es incorrecto, entonces devolvemos YA un -4
			if ( ($email_usuario == NULL) || ($nombre_usuario == NULL) || ($email_usuario == ' ') || ($nombre_usuario == ' ') ){
				$estado_registro = -4;
			}
			//Si el estado de registro aún es nulo, todo va bien:
			if ($estado_registro == NULL){
				//Validamos el email:
				if (Usuario::exists($email_usuario)){
					$estado_registro = -1;
				}
			}

			//Aquí es dónde viene el quid de la cuestión, cuando es un registro sin password, no creamos cliente
				// ==> No necesitamos crear NADA en la base de datos
				// ==> Guardamos el objeto usuario que vamos a crear en la sesión
				// ==> No enviamos ningún tipo de email

			if ($estado_registro == NULL){
				//Vamos a crear un cliente sin código y lo vamos a meter en la sesión:
				$datos_cliente = array(
					'nombre_comercial' => $nombre_usuario,
					'nombre_legal' => $nombre_usuario,
					'email' => $email_usuario,
				);
				$usuarioSinRegistro = new UsuarioSinRegistro($datos_cliente);
				//Hay que setear el usuario en la sesión, pero dejando claro que es un usuario sin registro:
				Sesion::set('usuarioSinRegistro', $usuarioSinRegistro);
				//Si hay que redirigir a los usuarios, lo hacemos
				if ($redirigir_a != NULL){
					//Redirigimos desde la sesión para que se haga el "commit" actual
					Sesion::reloadPage(Shop::$configuracion->url . $redirigir_a);
				}
			}
			//Llegados a este punto, si el estado de registro es menor o igual que 0, es que ha habido un error
			if ($estado_registro <= 0){
				Sesion::set('estado_registro', $estado_registro);
				$datos_usuario_registro = array(
					'email_usuario' => $email_usuario,
					'nombre_usuario' => $nombre_usuario,
				);
				Sesion::set('datos_usuario_registro', $datos_usuario_registro);
			}else{
				//En caso contrario, nos aseguramos de eliminar de la sesión el estado del registro:
				Sesion::remove('estado_registro');
				Sesion::remove('datos_usuario_registro');
			}
			//Recargamos la página
			Sesion::setReloadPage(Sesion::getReloadPage() | true);
		}else{
			//Si hay error, no hay que hacer nada, ya lo hace la web sola
		}
	}