<?php

  /* ================================================================= -->
      J.Rueda (01/09/2020)  Sección de listado de códigos promocionales -->
     ================================================================= */

  //Vamos a ver si hemos recibido un código promocional para guardarlo:
  $codigo_promocional = Getter::get('codigo_promocional', NULL);
  
  if ($codigo_promocional !== NULL) {
    $codigo = Getter::get('codigo', NULL);
    $fecha_alta = Getter::get('fecha_alta', NULL);
    $fecha_baja = Getter::get('fecha_baja', NULL);
    $descuento = Getter::get('descuento', NULL);
    $activo = Getter::get('activo', NULL);
    $g_envio_gratis = Getter::get('g_envio_gratis', NULL);
    $escaparates = Getter::get('escaparates', NULL);
    $lote = Getter::get('lote', NULL);
    $numUsos = Getter::get('numUsos', NULL);
    $campos = array();

    if($codigo != NULL){
      $campos['codigo'] = $codigo;
    }
    if($codigo_promocional != NULL){
        $campos['codigo_promocional'] = $codigo_promocional;
    }
    if($fecha_alta != NULL){
        $campos['fecha_alta'] = $fecha_alta;
    }
    if($fecha_baja != NULL){
        $campos['fecha_baja'] = $fecha_baja;
    }
    if($descuento != NULL){
        $campos['descuento'] = $descuento;
    }
    if($activo != NULL){
        $campos['activo'] = $activo;
    }
    if($g_envio_gratis != NULL){
        $campos['g_envio_gratis'] = ($g_envio_gratis == 'on' ? 1 : 0);
    }
    if($escaparates != NULL){
        $campos['escaparates'] = $escaparates;
    }
    if($lote != NULL){
        $campos['lote'] = $lote;
    }
    if($numUsos != NULL){
        $campos['numUsos'] = $numUsos;
    }

    // Si ya existe código es un update
    if($codigo == NULL){
      CodigosPromocionales::createCodigoPromocional($campos);
    }else{
      CodigosPromocionales::updateField($codigo, array_keys($campos), $campos);
    }
  }

    // 04/09/2020 - J.Rueda - Cargamos el listado de escaparates
    $arrEscaparates = Escaparate::getListaEscaparates();

?>
<script>
  
  var arrEscaparates = [];

  <?php 
    foreach ($arrEscaparates as $codigo=>$valor) { ?>
      arrEscaparates[<?=$codigo?>] = '<?=$valor?>';
    <?php } ?>

</script>

<!-- ============================================================== -->
<!-- Marina (23/08/2019)  INSERTAR NUEVO -->
<!-- ============================================================== -->


<div class="card m-b-0">
  <div class="card-header" id="headingOne">
    <h5 class="mb-0">
      <a data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
        <i class="m-r-5 mdi mdi-open-in-new" aria-hidden="true"></i>
          <span><?=traducir('Nuevo');?></span>
      </a>
    </h5>
  </div>
  <div id="collapseOne" class="collapse " aria-labelledby="headingOne" data-parent="#accordionExample">
    <div class="card-body">
     	<form class="row" method="post" action="<?=Shop::$configuracion->url . Sections::$current_section;?>">
        <div class="card-body">
          <h4 class="card-title"><?=traducir('Añadir nuevo código promocional');?></h4>
          <div class="row">
         		<div class="col-md-12 row">
              <?php
                //Vamos a poner un formulario para crear codigo promocional
              ?>
              <div class="form-group col-lg-3">
                <label for="fcod" class="col-md-12 font-bold"><?=traducir('Código promocional');?></label>
                <input type="text" name="codigo_promocional" class="form-control" id="fcod" placeholder="<?=traducir('Código promocional');?>"/>
              </div>
              <div class="form-group col-lg-3">
                <label for="fecha_alta" class="col-md-12 font-bold"><?=traducir('Fecha de alta');?></label>
                <input type="datetime-local" class="form-control" name="fecha_alta" id="fecha_alta"/>
              </div>
              <div class="form-group col-lg-3">
                <label for="fecha_baja" class="col-md-12 font-bold"><?=traducir('Fecha de baja');?></label>
                <input type="datetime-local" class="form-control" id="fecha_baja" name="fecha_baja"/>
              </div>
              <div class="form-group col-lg-3">
                <div class="input-group">
                  <label for="descuento" class="col-md-12 font-bold"><?=traducir('Descuento');?></label>
                    <input type="number" name="descuento" id="descuento" class="form-control" min="0" max="100" placeholder="0" required>
                    <div class="input-group-append">
                        <span class="input-group-text" id="basic-addon2">%</span>
                    </div>
                </div>
              </div>
            </div>

            <div class="col-12 row">
              <div class="form-group col-lg-4">
                <label for="listEscaparate" class="col-md-12 font-bold"><?=traducir('Escaparates: ');?></label>
                <div class="ui-widget">
                  <select class="select2 form-control custom-select" id="listEscaparate" name="escaparates">
                    <option value="" selected>Todos los escaparates</option>
                    <?php
                    foreach ($arrEscaparates as $codigo=>$valor) {
                      ?>
                      <option value="<?= $codigo ?>"><?= $valor ?></option>
                      <?php
                    }
                    ?>
                  </select>
                  <!-- <button id="setEscaparate" class="btn btn-default btn-small"><?=traducir('Añadir');?></button> -->
                </div>
              </div>
              <div class="form-group col-lg-4">
                <label for="g_envio_gratis" class="col-md-12 font-bold"><?=traducir('Gastos de envío gratis');?></label>
                <div class="checkbox custom-control custom-checkbox">
                  <input type="checkbox" name="g_envio_gratis" id="g_envio_gratis" class="switch">
                  <label for="g_envio_gratis" class=""><?=traducir('Activar gastos de envío gratis');?></label>
                </div>
              </div>
              <div class="form-group col-lg-4">
                <div class="row col-lg-12">
                  <label for="limitarUsos" class="col-md-12 font-bold"><?=traducir('Limitar número de usos');?></label>
                  <div class="numUsos">
                    <div class="custom-control custom-checkbox checkbox">
                      <input type="checkbox" id="limitarUsos">
                      <label for="limitarUsos"><?=traducir('Limitar a: ');?></label>
                    </div>
                      <!-- <label><?=traducir('Número de usos');?></label> -->
                    <input type="number" id="numUsos" name="numUsos" class="form-control" value="0" min="0" disabled>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="border-top">
          <div class="card-body">
            <input type="submit" name="crear_codigo" class="btn btn-primary" id="crear_codigo" value="Crear"/>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  document.addEventListener('WSLE', (event) => {

  // Evitar reenvío de parámetros POST
  if ( window.history.replaceState ) {
    window.history.replaceState( null, null, window.location.href );
  }

  // Campo "Limitar usos" en el formulario de nuevo
  $("#limitarUsos").on('click', function () {

    if (!$(this).is(':checked')) {
      $("#numUsos").prop('disabled', true);
      $("#numUsos").val(0);
    } else {
      $("#numUsos").prop('disabled', false);
    }
  });

  //Control del borrado de los códigos promocionales:
    $("form.formBorrarCodigoPromocional").submit( (event) => {
      event.preventDefault();
      const codigo = $(event.currentTarget).find('input[name=\'codigo\']').val();
      if (confirm('¿Desea eliminar este código promocional?')){
        var valor = {codigo};

        WS_data_update(
          'CodigosPromocionales',
          'removeCodigoPromocional',
          valor,
          '',
          (data) => {
            data = JSON.parse(data.response);
            var resultado = data.resultado;
            if ( (resultado === true) ){
              $(event.currentTarget).closest("tr").addClass("bg-danger").delay(1).hide(300);//.delay(300).remove();
              $("#msg").removeClass("alert-danger").addClass("alert-success");
              $("#msg").html("Código promocional eliminado correctamente.").show(300).delay(5000).hide(300);
            }else{
              $("#msg").removeClass("alert-success").addClass("alert-danger");
              $("#msg").html("Error al eliminar el código promocional").show(300).delay(5000).hide(300);
            }
          }
        );
      }
    });

    //Doble click en las líneas
    $('table.tabla_CodigosPromocionales td').on("dblclick", function(){
      guardarDato();
      //Ocultamos el span:
      $(this).find('span').addClass('hide');
      //Mostramos el input y le añadimos la clase visible para marcarlo
      $(this).find('input').removeClass('hide');
      $(this).find('input').addClass('visible');
      $(this).find('input').focus();
      
      //Por si es un select:
      $(this).find('select').removeClass('hide');
      $(this).find('select').addClass('visible');
      $(this).find('select').focus();	

      //Por si es un textarea:
      $(this).find('textarea').removeClass('hide');
      $(this).find('textarea').addClass('visible');
      $(this).find('textarea').focus();
    });
    //Pierde foco del campo
    $('td input, td select, td textarea').on("blur", function(){
      guardarDato();
    });
    //Pierde el foco con un enter:
    $('td input, td select, td textarea').keyup(function(e){
      if(e.keyCode == 13){
        guardarDato();
      }
    });
    //Se selecciona un elemento del select:
    $('td select').on("change", function(){
      guardarDato();
    });
    //Se activa o desactiva un checkbox
    $('td input[type=checkbox]').change(function () {
      sendData($(this));
    });
    
    function guardarDato(){
      //Esta función coge todos los td input abiertos, mira sus valores y se los envía al servidor:
      $('td input.visible, td select.visible, td textarea.visible').each(function(){
        //Vamos a ver si este input ha cambiado:
        sendData($(this));
      });
    }
    
    function sendData(elemento){

      var valorElemento = '';

      if (elemento.prop('type') === 'checkbox') {
        valorElemento = elemento.is(':checked') ? 1 : 0;
      } else {
        valorElemento = elemento.val();
      }

      if (elemento.data('previo') !== valorElemento){
        //TODO Aquí es dónde hay que hacer el envío, actualizar el span y el data-previo
        var valor = {id : elemento.data('codigo'), fieldName: elemento.data('campo'), value: valorElemento};

        WS_data_update(
          'CodigosPromocionales',
          'updateField',
          valor,
          '',
          function(data){
            data = JSON.parse(data.response);
            var resultado = data.resultado;

            if (elemento.data('campo') === 'escaparates') {
              elemento.data('previo', resultado);
              elemento.closest('td').find('span').html(arrEscaparates[resultado]);

            } else if (elemento.data('campo') === 'fecha_alta' ||
                       elemento.data('campo') === 'fecha_baja'){
              elemento.val((new Date(resultado)).toISOString().slice(0,16));
              elemento.data('previo', (new Date(resultado)).toISOString().slice(0,16));
              elemento.closest('td').find('span').html(resultado);

            } else {
              elemento.val(resultado);
              elemento.data('previo', resultado);
              elemento.closest('td').find('span').html(resultado);
            }
          }
        );
      }

      elemento.removeClass('visible');
      elemento.addClass('hide');
      elemento.closest('td').find('span').removeClass('hide');
    }

  });
</script>