<?php
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Función más básica que vamos a utilizar para recoger las variables que nos envíen por get o post o para capturarlas de las variables globales
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	

	function dame_valor_variable_global($nombre_variable, $valor_por_defecto = '', $decodificar = true){
		//Lo primero es ver si hemos recibido alguna variable con ese nombre por get o por put
		$asignar_valor = false;
		$valor_variable = '';
		if ( isset($_POST[$nombre_variable]) ){
			//Hemos recibido el valor de la variable por post
			$valor_variable = $_POST[$nombre_variable];
			$asignar_valor = true;
		}else if ( isset($_GET[$nombre_variable]) ){
			//Hemos recibido el valor de la variable por get
			//$valor_variable = iconv('UTF-8', 'ISO-8859-1//TRANSLIT', $_GET[$nombre_variable]); //==> ya no es necesaria hacer esta conversión
			$valor_variable = $_GET[$nombre_variable];
			$asignar_valor = true;
		}
		if ($decodificar){
			$valor_variable = descodificar_cadena($valor_variable);
		}else{
			$valor_variable = $valor_variable;
		}
		if ($asignar_valor){
			$GLOBALS[$nombre_variable] = $valor_variable;
		}
		if ( !isset($GLOBALS[$nombre_variable]) ){
			$GLOBALS[$nombre_variable] = $valor_por_defecto;
		}
		return($GLOBALS[$nombre_variable]);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FIN Función más básica que vamos a utilizar para recoger las variables que nos envíen por get o post o para capturarlas de las variables globales
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

	
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FUNCIONES USADAS PARA CODIFICAR/DESCODIFICAR TEXTO
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	/*function decrypt($string){
	   $result = '';
		$key = 'ARMINET555';
	   $string = base64_decode($string);
	   for($i=0; $i<strlen($string); $i++) {
		  $char = substr($string, $i, 1);
		  $keychar = substr($key, ($i % strlen($key))-1, 1);
		  $char = chr(ord($char)-ord($keychar));
		  $result.=$char;
	   }
	   return $result;
	}

	function encrypt($string){
	   $result = '';
   	   $key = 'ARMINET555';
	   for($i=0; $i<strlen($string); $i++) {
		  $char = substr($string, $i, 1);
		  $keychar = substr($key, ($i % strlen($key))-1, 1);
		  $char = chr(ord($char)+ord($keychar));
		  $result.=$char;
	   }
	   return base64_encode($result);
	}
	*/
	function descodificar_cadena($cadena){
		$cadena = html_entity_decode($cadena);
		return($cadena);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FIN FUNCIONES USADAS PARA CODIFICAR/DESCODIFICAR TEXTO
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FUNCION QUE HACE EL INCLUDE DEL CONTENIDO ACTUAL
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	function muestra_contenido($seccion_a_mostrar = ''){
		//Tenemos que cargar las variables globales de la web para que estén disponibles en todas las secciones
		include('comunes/globals.php');
		$retorno = false;
		if ($seccion_a_mostrar == ''){
			$seccion_a_mostrar = Sections::$current_section;
		}
		
		$fichero_a_incluir = Theme::findFile($seccion_a_mostrar . '.php');
		
		//echo("Hay que cargar la sección $fichero_a_incluir");
		
		//Si tenemos fichero para incluir, lo incluimos, en caso contrario no incluimos nada
		if ($fichero_a_incluir != NULL){
			$retorno = true;
			include($fichero_a_incluir);
		}else{
			echo('Error al intentar abrir la sección $fichero_a_incluir<br />\n');
		}
		
		//Devolvemos el resultado de la operación
		return($retorno);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FIN FUNCION QUE HACE EL INCLUDE DEL CONTENIDO ACTUAL
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Corregimos una url
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	function corregir_url($url, $entities = true){
		//Modificado por Pedro el 21/Enero/2018 ==> Quitamos la Ñ de este filtrado
		//Vamos a intentar que la url no tenga caracteres html utilizando el símbolo &
		$url = htmlspecialchars_decode($url);
		//Sustituimos las tildes y las ñ
		$find = array('á', 'é', 'í', 'ó', 'ú', 'Á', 'É', 'Í', 'Ó', 'Ú', 'à', 'è', 'ì', 'ò', 'ù', 'À', 'È', 'Ì', 'Ò', 'Ù', 'ä', 'ë', 'ï', 'ö', 'ü', 'Ä', 'Ë', 'Ï', 'Ö', 'Ü', "'", "´", '"', "(", ")", "&", " ", "º", "ª", "?", "¿", "!", "¡", "&", "+", 'ç', 'Ç', '%');
		$repl = array('a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U', "", "", '', "(", ")", "_", "-", "_", "_", "", "", "", "", "&amp;", "_", 'c', 'C', '', '-');
		$url = str_replace($find, $repl, $url);
		//Si queremos convertir las entidades, lo hacemos aquí
		if ($entities){
			$url = htmlentities($url);
		}else{
			//En caso contrario las decodificamos
			$url = html_entity_decode($url);
		}
		// Tranformamos todo a minusculas
		$url = strtolower($url);
		//Devolvemos la url compuesta
		return($url);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Quitar tildes
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	function quitar_tildes($cadena){
		$find = array('á', 'é', 'í', 'ó', 'ú', 'Á', 'É', 'Í', 'Ó', 'Ú', "ä", "ë", "ï", "ö", "ü", "Ä", "Ë", "Ï", "Ö", "Ü");
		$repl = array('a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U' );
		$cadena = str_replace($find, $repl, $cadena);
		return($cadena);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FIN Quitar tildes
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Mostramos un dato en pantalla utilizando un titular antes, y teniendo en cuenta si éste se tiene que mostrar o no (el titular)
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	function fich_muestra_dato($dato, $nombre_dato, $tipo_capa = 'p', $mostrar_siempre = false){
		include('comunes/globals.php');
		$numerico = true;
		if (gettype($dato) == 'string'){
			$numerico = false;
		}
		//Lo primero es evaluar si el dato se tiene que mostrar o no
		$mostrar_dato = false;
		if ($mostrar_siempre){
			$mostrar_dato = true;
		}else{
			if ( ($numerico) && ($dato > 0) ){
				$mostrar_dato = true;
			}
			if ( (!$numerico) && ($dato != '') ){
				$mostrar_dato = true;
			}
		}
		/*
		if ($numerico){
			echo("Es numerico<br />\n");
		}else{
			echo("NO es numerico<br />\n");
		}
		*/
		if ($mostrar_dato){
?>
<<?=$tipo_capa;?> class="<?=$dato;?>"><span class="nombre_dato"><?=traducir($nombre_dato);?>: </span><strong class="dato"><?=htmlentities($dato);?></strong></<?=$tipo_capa;?>>
<?php
		}
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FIN Mostramos un dato en pantalla utilizando un titular antes, y teniendo en cuenta si éste se tiene que mostrar o no (el titular)
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	//Esta función devuelve un array estandar para el "lanzador_widget"
	function LW_params(){
		return(array('nombre'=>'lanzador_widget', 'funcion'=> 'lanzador_widget'));
	}
	
	function mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos){
		$array_final = array();
		//Como hay que recorrer ambos arrays, tengo que coger el más grande como referencia
		$longitud_maxima = max(count($parametros_por_defecto), count($parametros_recibidos));
		for ($i = 0; $i < $longitud_maxima; $i++){
			if (array_key_exists($i, $parametros_recibidos)){
			//if (isset($parametros_recibidos[$i])){
				$array_final[$i] = $parametros_recibidos[$i];
			}else{
				$array_final[$i] = $parametros_por_defecto[$i];
			}
			//$array_final[$i] = ($parametros_recibidos[$i] != NULL)? $parametros_recibidos[$i] : $parametros_por_defecto[$i];
		}
		return($array_final);
	}
	
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// LOG
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	function grabarLog($cadena){
		$fichero = fopen('log/log.txt', 'a+');
		fwrite($fichero, "$cadena\r\n");
		fclose($fichero);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// LOG
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

	function buscar_fichero_configuracion($ruta_origen){
		$retorno = $ruta_origen;
		$array_ruta = explode('/', $ruta_origen);
		unset($array_ruta[count($array_ruta) - 1]);
		$directorio = implode('/', $array_ruta);
		//Vamos a intentar cambiar al directorio especificado.
		$dir_actual = getcwd();

		return($retorno);
	}

	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// CAPTCHA
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	function checkCaptcha($token){
		include('comunes/globals.php');
		$retorno = false;
		$url = 'https://www.google.com/recaptcha/api/siteverify?secret=' . Shop::$configuracion->captchaClaveSecreta . "&response=$token";
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$resultado = curl_exec($ch);
		$resultado = json_decode($resultado, true);
		if ($resultado != NULL){
			$retorno = $resultado['success'];
		}
		curl_close($ch);
		return($retorno);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// CAPTCHA
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// DOMINIO Y CARPETA DEL MISMO
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	function dominio(){
		/*include('comunes/globals.php');
		$aux_dominio = Shop::$configuracion->url;
		//Le quitamos la / final al dominio
		if (substr($aux_dominio, -1) == '/'){
			$aux_dominio = substr($aux_dominio, 0, strlen($aux_dominio) - 1);
		}
		//Ahora quitamos el http://
		$aux_dominio = str_replace('https://', '', $aux_dominio);
		//Vamos a dividir el dominio en un array separando por los "/"
		$array_dominio = explode('/', $aux_dominio);

		$aux_dominio = "";
		$total = count($array_dominio);
		//echo("Hay $total elementos <br />\n");
		if ($total > 1){ //Cuando haya varios directorios, cogemos siempre hasta el final menos 1
			$total--;
		}
		//echo("Hay $total elementos <br />\n");
		for ($i = 0; $i < $total; $i++){
			$aux_dominio .= (($aux_dominio != '') ? '/' : '') . $array_dominio[$i];
		}
		//echo("El nombre de dominio es: $dominio<br />\n");
		return($aux_dominio);
		*/
		include("comunes/globals.php");
		$aux_dominio = preg_replace('/https?:\\/\\/(.+)\\/(.*)\\/?/', '$1', Shop::$configuracion->url);
		//Vamos a quitar las "www."
		$aux_dominio = str_replace('www.', '', $aux_dominio);
		//Vamos a coger la carpeta el dominio para qiutarla del propio dominio:
		$carpeta_dominio = carpeta_dominio();
		$aux_dominio = str_replace($carpeta_dominio, "", $aux_dominio);
		return($aux_dominio);
	}
	function carpeta_dominio(){
		include('comunes/globals.php');
		$aux_dominio = Shop::$configuracion->url;
		//Le quitamos la / final al dominio
		if (substr($aux_dominio, -1) == '/'){
			$aux_dominio = substr($aux_dominio, 0, strlen($aux_dominio) - 1);
		}
		//Ahora quitamos el http://
		$aux_dominio = str_replace('https://', '', $aux_dominio);
		$carpeta = '/';
		//Vamos a dividir el dominio en un array separando por los '/'
		$array_dominio = explode('/', $aux_dominio);
		$total = count($array_dominio) - 1;
		if ($total > 1){
			$carpeta .= $array_dominio[$total];
		}
		return($carpeta);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// DOMINIO Y CARPETA DEL MISMO
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	

	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// comprobamos si existe un fichero teniendo en cuenta el include_path
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	function existe_fichero($ruta_relativa){
		$retorno = false;
		$lista_rutas = explode(PATH_SEPARATOR, get_include_path());
		foreach($lista_rutas as $ruta){
			//si $p no termina en / se la ponemos
			if ( (substr($ruta, -1) != '/') && (substr($ruta_relativa, 0, 1) != '/') ){
				$ruta .= '/';
			}
			if(file_exists($ruta . $ruta_relativa)){
				$retorno = $ruta . $ruta_relativa;
				break;
			}
		}
		if ($retorno){
			//echo("localizado: " . $ruta . $ruta_relativa . "<br />\n");
		}
		return($retorno);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// comprobamos si existe un fichero teniendo en cuenta el include_path
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FUNCIONES RELACIONADAS CON LAS FECHAS
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	function dame_dia_de_la_semana($dia){
	$nombre = "";
	switch ($dia){
		case 1:
			$nombre = 'Lunes';
			break;
		case 2:
			$nombre = 'Martes';
			break;
		case 3:
			$nombre = 'Miércoles';
			break;
		case 4:
			$nombre = 'Jueves';
			break;
		case 5:
			$nombre = 'Viernes';
			break;
		case 6:
			$nombre = 'Sábado';
			break;
		case 0:
			$nombre = 'Domingo';
			break;
	}
	return($nombre);
}
//Marina -- 28/agosto/2020 quito los traducir mientras no esta pedro por NECESIDAD para que no salgan en los emails en tantos clientes.
function dame_mes($mes){
	$nombre = '';
	switch ($mes){
		case 1:
			$nombre = 'Enero';
			break;
		case 2:
			$nombre = 'Febrero';
			break;
		case 3:
			$nombre = 'Marzo';
			break;
		case 4:
			$nombre = 'Abril';
			break;
		case 5:
			$nombre = 'Mayo';
			break;
		case 6:
			$nombre = 'Junio';
			break;
		case 7:
			$nombre = 'Julio';
			break;
		case 8:
			$nombre = 'Agosto';
			break;
		case 9:
			$nombre = 'Septiembre';
			break;
		case 10:
			$nombre = 'Octubre';
			break;
		case 11:
			$nombre = 'Noviembre';
			break;
		case 12:
			$nombre = 'Diciembre';
			break;
	}
	return($nombre);
}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FUNCIONES RELACIONADAS CON LAS FECHAS
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	


	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Búsqueda de un fichero dentro de las RUTAS
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
/*	function buscaPerso($fichero, $relativa = false){
		//include('comunes/globals.php');

		$retorno = NULL;
		$encontrado = false;
		$extension = strtoupper(substr($fichero, -4));
		if ($fichero != ''){
			if (isset($ruta_ficheros_web[$fichero])){
				$ruta_absoluta = $ruta_ficheros_web[$fichero];
				//echo("Buscamos " . $ruta_absoluta . "\n<BR />");
				if ( isset($ruta_absoluta) ){
					if ($retorno = realpath($ruta_absoluta)) {
						//var_dump($ruta_absoluta);
						$ruta_tmp = $ruta_absoluta;
						if ($relativa){
							$retorno = $fichero;
						}
					}
				}
			}
		}
		
		
	}
	*/
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Búsqueda de un fichero dentro de las RUTAS
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	

	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Función que carga el fichero correspondiente según estemos en movil/perso/base
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	function loadFile($ruta, $opcional = '', $joined = false, $cadParametros = ''){
		$retorno = false;
		include('comunes/globals.php');
		$ruta = Theme::findFile($ruta, false);
		if ($ruta != NULL){
			//Según el tipo de fichero hacemos una cosa u otra:
			$extension = explode('.', $ruta);
			$extension = $extension[count($extension) - 1];
			if (existe_fichero($ruta) !== false){
				if ($extension == 'js'){
					/*
					//Para los ficheros javascript vamos a meter cómo parametro el hash de la sesión
					if (strpos($ruta, 'cesta.js') !== false){
						$ruta .= '?' . genera_cod_seguridad();
					}
					*/
					if ($joined){
						$contenidoScriptsUnidos .= ( ($contenidoScriptsUnidos!='')?'|':'') . $ruta;
					}else{
?>
<script type="text/javascript" src="<?=Shop::$configuracion->url . $ruta . (($cadParametros!='')?'?'.$cadParametros:'');?>"></script>
<?php
					}
				}else if  ($extension == 'css'){
					if ($joined){
						$contenidoEstilosUnidos .= ( ($contenidoEstilosUnidos!='')?'|':'') . $ruta;
					}else{
?>
<link rel="stylesheet" type="text/css" href="<?=Shop::$configuracion->url . $ruta . (($cadParametros!='')?'?'.$cadParametros:'');?>" <?=$opcional;?>>
<?php
					}
				}
				$retorno = true;
			}
		}
		return($retorno);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Función que carga el fichero correspondiente según estemos en movil/perso/base
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Localizamos un fichero, por defecto el config.sys
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	/*function localizaConfigSys($nombre_fichero = 'config.sys'){
		$correcto = false;
		//Para agilizar el proceso, vamos a empezar buscando el fichero en el directorio actual por si las moscas
		if(file_exists('./' . $nombre_fichero)){		
			$retorno = './' . $nombre_fichero;
		}else{
			//Vamos a obtener el directorio actual
			$directorio_actual = explode('/', getcwd());
			$profundidad = count($directorio_actual);
			$ruta_comprobacion = '';
			for ($i = 0; ($i < $profundidad) && (!$correcto); $i++){
				
				//Si tenemos algo en $directorio_actual[$i] (no está vacío) continuamos
				if (trim($directorio_actual[$i]) != ''){
					$ruta_comprobacion .= '/' . $directorio_actual[$i];
					//var_dump($ruta_comprobacion);
					if (file_exists($ruta_comprobacion . '/' . $nombre_fichero)){
						$correcto = true;
					}
				}
			}
			if (!$correcto){
				$retorno = NULL;
			}else{
				$retorno = $ruta_comprobacion . '/' . $nombre_fichero;
			}
			
		}
		
		return($retorno);
	}*/
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Localizamos un fichero, por defecto el config.sys
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	

	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Errores de pasarela
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	function txt_error_pasarela($codigo){
		$retorno = 'Error sin identificar';
		switch($codigo){
			case 101:
				$retorno = 'Tarjeta caducada';
			break;
			case 102:
				$retorno = 'Tarjeta en excepción transitoria o bajo sospecha de fraude';
			break;
			case 106:
				$retorno = 'Intentos de PIN excedidos';
			break;
			case 125:
				$retorno = 'Tarjeta no efectiva';
			break;
			case 129:
				$retorno = 'Código de seguridad (CVV2/CVC2) incorrecto';
			break;
			case 180:
				$retorno = 'Tarjeta ajena al servicio';
			break;
			case 184:
				$retorno = 'Error en la autenticación del titular';
			break;
			case 190:
				$retorno = 'Denegación sin especificar Motivo';
			break;
			case 191:
				$retorno = 'Fecha de caducidad errónea';
			break;
			case 202:
				$retorno = 'Tarjeta en excepción transitoria o bajo sospecha de fraude con retirada de tarjetaa';
			break;
			case 904:
				$retorno = 'Comercio no registrado en FUC';
			break;
			case 909:
			case 9912:
				$retorno = 'Error de sistema';
			break;
			case 912:
				$retorno = 'Emisor no disponible';
			break;
			case 950:
				$retorno = 'Operación de devolución no permitida';
			break;
			case 9064:
				$retorno = 'Número de posiciones de la tarjeta incorrecto';
			break;
			case 9078:
				$retorno = 'No existe método de pago válido para esa tarjeta';
			break;
			case 9093:
				$retorno = 'Tarjeta no existente';
			break;
			case 9218:
				$retorno = 'El comercio no permite op. seguras por entrada /operaciones';
			break;
			case 9253:
				$retorno = 'Tarjeta no cumple el check-digit';
			break;
			case 9256:
				$retorno = 'El comercio no puede realizar preautorizaciones';
			break;
			case 9257:
				$retorno = 'Esta tarjeta no permite operativa de preautorizaciones';
			break;
			case 9261:
				$retorno = 'Operación detenida por superar el control de restricciones en la entrada al SIS';
			break;
			case 9913:
				$retorno = 'Error en la confirmación que el comercio envía al TPV Virtual (solo aplicable en la opción de sincronización SOAP)';
			break;
			case 9914:
				$retorno = 'Confirmación “KO” del comercio (solo aplicable en la opción de sincronización SOAP)';
			break;
			case 9928:
				$retorno = 'Anulación de autorización en diferido realizada por el SIS (proceso batch)';
			break;
			case 9929:
				$retorno = 'Anulación de autorización en diferido realizada por el comercio';
			break;
			case 9104:
				$retorno = 'Comercio con “titular seguro” y titular sin clave de compra segura';
			break;
			case 9915:
				$retorno = 'A petición del usuario se ha cancelado el pago';
			break;
			case 9094:
				$retorno = 'Rechazo servidores internacionales';
			break;
			case 944:
				$retorno = 'Sesión Incorrecta';
			break;
			case 913:
				$retorno = 'Pedido repetido';
			break;
		}
		return($retorno);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FIN Errores de pasarela
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	

	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// Función que anota el log en un fichero
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	function anotarLog($texto){
		include('comunes/globals.php');
		if ($log){
			$fecha_hora = getdate();
			$nombre_fichero = $fecha_hora['year'] . $fecha_hora['mon'] . $fecha_hora['mday'] . $fecha_hora['hours'] . '.log';
			if ($fichero = fopen("log/$nombre_fichero", "a")){
				fwrite($fichero, $texto . '\r\n');
				fclose($fichero);	
			}
		}
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FIN Función que anota el log en un fichero
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// meter en strong la primera letra de cada cadena
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	function strongFirstLetter($cadena){
		$array_cadena = explode(' ', $cadena);
		$nueva_cadena = '';
		foreach($array_cadena as $clave => $valor){
			$caracter = substr( $valor, 0,1 );
			$palabra = substr( $valor, 1);
			
			$nueva_cadena .= ($nueva_cadena != '') ? ' ' : '';
			$nueva_cadena .= '<strong>' . $caracter . '</strong>' . $palabra;
		}
		return($nueva_cadena);
	}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FINmeter en strong la primera letra de cada cadena
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// meter en strong la primera letra de cada cadena
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	function adaptar_filtrado(){
		include('comunes/globals.php');
		//Vamos a coger dos variables, una con el filtrado que nos manden en la URL y otra con el filtrado que tenemos en la sesión
		$filtrado_nuevo = dame_valor_variable_global('filtrado_actual', '');
		$filtrado_anterior = Sesion::get('filtrado_actual');
		//echo("Filtrados:$filtrado_anterior-$filtrado_nuevo");
		$filtrado_final = array();
		//Si no hay filtrado anterior, entonces se hace la asignación directamente:
		//Si hay filtrado anterior y también hay uno nuevo, tenemos que ir comprobando que hay en el filtrado:
		if ($filtrado_anterior != ""){
			//Vamos a meter ambos filtrados en un array dónde la clave sea el campo a filtrar y el valor sea el contenido:
			$filtrado = explode('*', $filtrado_anterior);
			foreach($filtrado as $clave => $valor){
				if ($valor != ''){
					//En cada '$valor' que tengo, hay un par de valores: campo:valores. hay que separarlos
					$par_valores = explode(':', $valor);
					$filtrado_final[$par_valores[0]] = $par_valores[1];
				}
			}
		}
		if ($filtrado_nuevo != ''){
			//Ahora hacemos lo mismo con el nuevo
			$filtrado = explode('*', $filtrado_nuevo);
			foreach($filtrado as $clave => $valor){
				if ($valor != ''){
					//En cada '$valor' que tengo, hay un par de valores: campo:valores. hay que separarlos
					$par_valores = explode(':', $valor);
					$filtrado_final[$par_valores[0]] = $par_valores[1];
				}
			}
		}
		//En filtrado final tenemos un array con el filtrado a utilizar, vamos a componer la cadena del filtrado:
		$filtrado_anterior = '';
		foreach($filtrado_final as $clave => $valor){
			//Si el valor es "no" entonces es que este filtrado hay que quitarlo:
			if ($valor != "no"){
				$filtrado_anterior .= "*$clave:$valor";
			}
		}

		Sesion::set('filtrado_actual', $filtrado_anterior);
		return($filtrado_anterior);
	}

	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	// FIN meter en strong la primera letra de cada cadena
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	
	function escupirMiga($texto = 'miga',$estandar= false, $separador = '-', $ruta = 'miga'){
		include('comunes/globals.php');
		$ruta_f = Theme::findFile($ruta. '.php');
		if ($ruta_f != NULL) {
			include($ruta_f);
		}
            
	}
?>