<?php
	//---------------------------------------------------------------------------------------------------------
	// 23/Octubre/2015
	// Versión 1.0 Recogemos los datos que utilizaremos en el orden y filtrado de depositos
	//---------------------------------------------------------------------------------------------------------

	

	include('comunes/globals.php');
	
	if (Usuario::logueado() != NULL){
		//Antes de comenzar con los procesos naturales de la sección, vamos a cargar el fichero de depósitos actual y a procesar todos los depósitos del cliente:
		ini_set('include_path', '../../' . PATH_SEPARATOR . get_include_path());
		$array_fichero_depositos = glob('importacion/import/DEPOSITOS.*', GLOB_BRACE );
		$conexionBD = dame_valor_variable_global('conexionBD', false);
		if ( count($array_fichero_depositos) > 0 ){
			//Vamos a abrir el primer elemento y a procesarlo
			if ($fich = fopen($array_fichero_depositos[0], 'r')){
				$linea = '';
				$estado = 0; //==> 0 = buscando, 1 = introduciendo, 2 = terminado
				//Nos saltamos las dos primeras líneas
				fgets($fich);
				fgets($fich);
				//Ahora vamos a leer los campos
				$linea = fgets($fich);
				$linea = substr($linea, 0, -3); //Quito el último caracter (cogemos la cadena desde 0, pero omitiendo 1 caracter por el final)
				$cad_campos = str_replace('|', ', ', $linea);
				//echo('Los campos son: $cad_campos<br />\n');
				if ($conexionBD){
					//Vamos a eliminar los depósitos que haya de este cliente:
					$sentencia_sql = 'DELETE FROM deposito WHERE cliente = ' . $datos_usuario->codigo_sinlib;
					//echo('se borran los depósitos:<br />\n$sentencia_sql<br />\n');
					mysqli_query($conexionBD, $sentencia_sql);
				}
				while ( ($linea = fgets($fich)) && ($estado < 2) ){
					//Hay que quitar el | del final:
					$linea = substr($linea, 0, -3);
					//Convertimos la línea a un array para una mejor comprensión
					$array_contenido_linea = explode('|', $linea);
					$array_contenido_linea = array_slice($array_contenido_linea, 2);
					//Vamos a procesar la línea
					//El código de cliente SIEMPRE ha de ir en la tercera posición
					$estado = 0;
					if ($datos_usuario->codigo_sinlib == $array_contenido_linea[3]){
						$estado = 1;
					}else if ($estado == 1){
						//Si no es el elemento que buscamos, y el estado ya ha pasado a 1, hay que pasarlo a 2.
						$estado = 2;
					}
					if ($estado == 1){
						//componemos la select:
						$valores = " '" . implode("', '", $array_contenido_linea) . "' ";
						if ($conexionBD){
							//Ahora insertamos los depósitos del cliente.
							$sentencia_sql = "INSERT INTO deposito ($cad_campos)
											VALUES
											($valores)";
											
							//echo("$sentencia_sql<br />\n");
							mysqli_query($conexionBD, $sentencia_sql);
						}
					}
				}
				fclose($fich);
			}
		}
	}

	//El funcionamiento es sencillo, miramos si alguna de las variables está activa en las cookies. En caso afirmativo las metemos en la sesión, limpiamos esas cookies
	//y recargamos la página
	
	//---------------------------------------------------------------------------------------------------------
	//Filtrados
	//---------------------------------------------------------------------------------------------------------
	$fecha_inicio_depositos = Sesion::getCookieValue('fecha_inicio');
	$fecha_fin_depositos = Sesion::getCookieValue('fecha_fin');
	$solo_libros_depositos = Sesion::getCookieValue('solo_libros');
	$solo_papeleria_depositos = Sesion::getCookieValue('solo_papeleria');

    $recargar_web = $recargar_web | false;
	//Si nos han pasado fecha de inicio la metemos en la sesión
	if ($fecha_inicio_depositos != NULL){
		Sesion::set('fecha_inicio_depositos', $fecha_inicio_depositos);
		borrarCookie('fecha_inicio');
        Sesion::setReloadPage(Sesion::getReloadPage() | true);
	}
	
	//Si nos han pasado fecha de fin, la metemos en la sesión
	if ($fecha_fin_depositos != NULL){
		Sesion::set('fecha_fin_depositos', $fecha_fin_depositos);
		borrarCookie('fecha_fin');
        Sesion::setReloadPage(Sesion::getReloadPage() | true);
	}

	//Si nos han pasado la opción de 'solo libros' la miramos en la sesión
	if ($solo_libros_depositos !== NULL){
		Sesion::set('solo_libros_depositos', $solo_libros_depositos);
		borrarCookie('solo_libros');
        Sesion::setReloadPage(Sesion::getReloadPage() | true);
	}

	//Si nos han pasado la opción de 'solo libros' la miramos en la sesión
	if ($solo_papeleria_depositos !== NULL){
		Sesion::set('solo_papeleria_depositos', $solo_papeleria_depositos);
		borrarCookie('solo_papeleria');
        Sesion::setReloadPage(Sesion::getReloadPage() | true);
	}
	//---------------------------------------------------------------------------------------------------------
	//Orden
	//---------------------------------------------------------------------------------------------------------
	$orden_depositos = Sesion::getCookieValue('orden');
	$tipo_orden_depositos = Sesion::getCookieValue('tipo_orden');
	//Controlamos si nos han pasado un orden
	if ($orden_depositos != NULL){
		Sesion::set('orden_depositos', $orden_depositos);
		borrarCookie('orden');
        Sesion::setReloadPage(Sesion::getReloadPage() | true);
	}
	//Hay que controlar el tipo de orden (ascendente o descendente)
	if ($tipo_orden_depositos != NULL){
		Sesion::set('tipo_orden_depositos', $tipo_orden_depositos);
		borrarCookie('tipo_orden');
        Sesion::setReloadPage(Sesion::getReloadPage() | true);
	}
	
	//---------------------------------------------------------------------------------------------------------
	//Limpiamos las cookies
	//---------------------------------------------------------------------------------------------------------
	$limpiar_filtrado= Sesion::getCookieValue('limpiar_filtrado');
	if ($limpiar_filtrado != NULL){
		Sesion::set('fecha_inicio_depositos', '');
		Sesion::set('fecha_fin_depositos', '');
		Sesion::set('solo_libros_depositos', '');
		Sesion::set('solo_papeleria_depositos', '');
		borrarCookie('limpiar_filtrado');
        Sesion::setReloadPage(Sesion::getReloadPage() | true);
	}
?>
