<?php

//---------------------------------------------------------------------------------------------------------
// 27/Enero/2017
// Versión 1.0 Widget para mostrar componentes del vendedor
//---------------------------------------------------------------------------------------------------------



function widget_vendedor() {
    include('comunes/globals.php');
    //Aquí definimos una serie de parámetros que necesitamos
    $funcion_por_defecto = 'paginador';
    $parametros_por_defecto = array();
    $parametros_recibidos = func_get_args();
    if (count($parametros_recibidos) == 0) {
        $parametros_recibidos[0] = $funcion_por_defecto;
    } else {
        if (($parametros_recibidos[0] == '') || ($parametros_recibidos[0] == NULL)) {
            $parametros_recibidos[0] = $funcion_por_defecto;
        }
    }
    $parametros_recibidos = mezcla_array_parametros($parametros_por_defecto, $parametros_recibidos);
    $retorno = false;
    //Si entre los parámetros recibidos, tenemos el nombre de la función continuamos
    if (count($parametros_recibidos) > 0) {
        //Recogemos el nombre de la función de entre el resto de parámetros
        $nombre_funcion = $parametros_recibidos[0];
        //Quitamos el primer elemento de los parámetros, pues es el nombre de la función
        $parametros_recibidos = array_slice($parametros_recibidos, 1);
        //Si la función existe la ejecutamos
        if (function_exists($nombre_funcion)) {
            $retorno = call_user_func_array($nombre_funcion, $parametros_recibidos);
        }
    }
    return($retorno);
}

function loginVendedor($opciones = NULL) {
    include('comunes/globals.php');
    $ficheroLoginVendedor = "loginVendedor";
    $ficheroLogoutVendedor = "logoutVendedor";
    $ficheroACargar = "";
    $ocultarCabecera = false;
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    if (is_a($opciones, 'OpcionesWidget')) {
        $ficheroLoginVendedor = ($opciones->configuracion->ficheroLoginVendedor != NULL) ? $opciones->configuracion->ficheroLoginVendedor : $ficheroLoginVendedor;
        $ficheroLogoutVendedor = ($opciones->configuracion->ficheroLogoutVendedor != NULL) ? $opciones->configuracion->ficheroLogoutVendedor : $ficheroLogoutVendedor;
        $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
        //Si el vendedor ya ha hecho login, no mostramos nada
        $vendedorActual = Sesion::get("vendedorActual");
        //Este es el widget de cerrar sesión del vendedor//Esto va para el widget posterior:
        if (($vendedorActual == 0) || ($vendedorActual == NULL)) {
            $ficheroACargar = $ficheroLoginVendedor;
        } else {
            $ficheroACargar = $ficheroLogoutVendedor;
        }
        if ($ficheroACargar != "") {
            $ruta_fichero = $ficheroACargar . '.php';
            $ruta_fichero = Theme::findFile($ruta_fichero);
            if ($ruta_fichero != NULL) {
                ?>
                <?php
                if (!$ocultarCabecera) {
                    ?>
                    <div class="<?= (__FUNCTION__); ?>">
                        <?php
                    }
                    ?>


                    <?php include($ruta_fichero); ?>
                    <?php
                    if (!$ocultarCabecera) {
                        ?>
                    </div>
                    <?php
                }
                ?>
                <?php
            }
        }
    }
}

function vendedorBuscadorCliente($opciones = NULL) {
    include('comunes/globals.php');
    $ficheroClienteEncontrado = 'vendedorClienteEncontrado';
    $ficheroBuscarCliente = 'vendedorBuscadorCliente';
    $ficheroACargar = "";
    $ocultarCabecera = false;
    if ($opciones == NULL) {
        $opciones = new OpcionesWidget();
    }
    //Por aquí no pasamos si no hay vendedor
    $vendedorActual = Sesion::get("vendedorActual");
    //var_dump($opciones);
    if ($vendedorActual > 0) {
        if (is_a($opciones, 'OpcionesWidget')) {
            $ficheroClienteEncontrado = ($opciones->configuracion->ficheroClienteEncontrado != NULL) ? $opciones->configuracion->ficheroClienteEncontrado : $ficheroClienteEncontrado;
            $ficheroBuscarCliente = ($opciones->configuracion->ficheroBuscarCliente != NULL) ? $opciones->configuracion->ficheroBuscarCliente : $ficheroBuscarCliente;
            $ocultarCabecera = ($opciones->configuracion->ocultarCabecera != NULL) ? $opciones->configuracion->ocultarCabecera : $ocultarCabecera;
            //Si el vendedor ya ha hecho login, no mostramos nada

            $clienteActual = Usuario::logueado();
            //Este es el widget de cerrar sesión del vendedor//Esto va para el widget posterior:
            if ($clienteActual == NULL) {
                $ficheroACargar = $ficheroBuscarCliente;
            } else {
                $ficheroACargar = $ficheroClienteEncontrado;
            }
            if ($ficheroACargar != "") {
                $ruta_fichero = $ficheroACargar . '.php';
                $ruta_fichero = Theme::findFile($ruta_fichero);
                if ($ruta_fichero != NULL) {
                    $nombre_script = 'script_' . incrementa_contador();
                    ?>
                    <?php
                    if (!$ocultarCabecera) {
                        ?>
                        <div class="<?= (__FUNCTION__); ?>">
                            <?php
                        }
                        ?>
                        <?php include($ruta_fichero); ?>
                        <script id="<?= $nombre_script; ?>">
						document.addEventListener('WSLE', function(event) {
                            ;(function () {
                                var enlace = getLastHtmlObject('<?= $nombre_script; ?>');
                                enlace.find("form.busquedaCliente").on("submit", function (event) {
                                    event.preventDefault();
                                    var datosUsuario = $(this).find('input[name="datosUsuario"]').val();
                                    var parametros = "datosUsuario=" + datosUsuario + "&hash=<?= genera_cod_seguridad(); ?>";
                                    var url = "<?= Shop::$configuracion->url; ?>comunes/consultas/buscarCliente.php";
                                    realizar_solicitud(url, parametros, function (respuesta) {
                                        enlace.find("form.seleccionarCliente").find("fieldset.listadoClientes").html(respuesta);
                                    });
                                });
                            })();
						});
                        </script>
                        <?php
                        if (!$ocultarCabecera) {
                            ?>
                        </div>
                        <?php
                    }
                    ?>
                    <?php
                }
            }
        }
    }
}
?>