<?php
/*
	Clase SuperBusqueda
	@version 1.0
*/

class SuperBusqueda extends Apartado{
	public static $campos_tabla = array();
	public static $alias = '';
	public static $nombreTabla = '';
	public static $camposSelect = '';
	public static $whereSelect = '';
	public static $publicFieldList = array();

	//Esta clase se usa para hacer búsquedas y podre mostrar los resultados
	public $busqueda_simple = '';
	public $titulo = '';
	public $nombre = ''; //El nombre lo usamos en la búsqueda avanzada, lo cambiamos por el título
	public $editorial = '';
	public $autor = '';
	public $isbn = '';
	public $ean = '';
	public $nombre_coleccion = '';
	public $nombreRealColeccion = '';
	public $categoria = '';
	public $tbusqueda = 'simple';/*0 = Normal 1 = Avanzada*/	
	const BUFFER_INDEXADO = 500;
	
	public static function getCampos($soloPrincipal = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		$aliasTabla = static::getAlias();
		//Los campos son los mismos que en la ficha del producto
		if (static::$nombreTabla != ''){
			$campos = Articulo::getCampos();
			static::$camposSelect = $campos;
		}
		
		return($campos);
	}
	
	public static function getNombreTabla($soloPrincipal = NULL){
		$idioma = Idioma::getCurrentLanguaje(true);
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		$nombre_tabla = static::$nombreTabla; //El nombre de la tabla se coge del nombre del padre
		//Cogemos las tablas de artículo más la de 'search_index'
		$consulta = $nombre_tabla . ' as `' .  static::getAlias() . '`, ' . Articulo::getNombreTabla();
		static::$nombreTabla = $consulta;
		return($consulta);
	}
	
	public static function getWhereTabla(){
		//La where aún no está definido como se compone
		$argumentos = func_get_args();
		//Siempre hay que filtrar "no web"
		static::$whereSelect = ' ( `' .  Articulo::getAlias() . '`.`no_web` = 0 ) ';
		//Ojo que siempre tenemos que fusionar ambas tablas:
		static::$whereSelect .= ' AND ( `' . static::getAlias() . '`.`articulo` = `' . Articulo::getAlias() . '`.`codigo` ) ';
		//El primer argumento es la búsqueda simple o bien un array con los pares de parámetro =>  valor
		$txt_busqueda = isset($argumentos[0]) ? $argumentos[0] : '';
		if (!is_array($txt_busqueda)){
			if ($txt_busqueda != ''){
				//Necesitamos descomponer el texto de búsqueda:
				static::$whereSelect .= ' AND ( ' . self::prepararCadenaBusqueda($txt_busqueda) . ' ) ';
			}
		}else{
			//Vamos a descomponer el array para hacer la búsqueda
			//var_dump($txt_busqueda);
			foreach($txt_busqueda as $campoBusqueda => $valorBusqueda){
				$camposArticulo = array('autor', 'titulo', 'editorial', 'nombre_coleccion', 'isbn', 'ean');
				if (in_array($campoBusqueda, $camposArticulo)){
					//Ojo, si nos pasan la palabra "título", la cambiamos por "nombre":
					$campoBusqueda = ($campoBusqueda == 'titulo') ? 'nombre' : $campoBusqueda;
					//En este caso son campos de la ficha del artículo, el alias a coger es de la propia ficha
					static::$whereSelect .= ' AND ' . self::prepararCadenaBusqueda($valorBusqueda, $campoBusqueda, 'Articulo', false, false);
				}else if(strtoupper($campoBusqueda) == 'CATEGORIA'){
					
				}else if(strtoupper($campoBusqueda) == 'NOMBREREALCOLECCION'){
					//Para el nombre real de la colección, lo metemos directamente
					//Aquí se podría hacer preparando la cadena de búsqueda también, pero lo dejo a modo de ejemplo
					static::$whereSelect .= ' AND `' . Articulo::getAlias() . '`.`nombre_coleccion` LIKE \'%' . $valorBusqueda . '%\'';
				}
			}
		}
		/*
		
		if (Shop::$configuracion->ocultar_stock_0) {
			static::$whereSelect .= (static::$whereSelect != '') ? ' AND ' : '';
			static::$whereSelect .= ' `' .  static::getAlias() . '`.`stock` > 0';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		*/
		return(static::$whereSelect);
	}
	
	private static function prepararCadenaBusqueda($txt_busqueda, $campo = 'valor', $tabla = NULL, $gestionarPlural = true, $soloPalabras = true){
		$resultado = '';
		$aliasTabla = static::getAlias();
		if ($tabla != NULL){
			$aliasTabla = $tabla::getAlias();
		}

		//echo("<!-- $txt_busqueda -->");
		//Pedro 31/Marzo/2020 ==> Vamos a quitar de la búsqueda todo lo "raro" que esté buscando el usuario, los guiones altos y bajos se convierten en espacios y todo lo que sea más de un espacio se reduce a 1:
		//Marina(20/07/2020) añado exclamaciones a la excepcion
		$txt_busqueda = preg_replace(
			array('/[^a-zA-Z0-9 ÁÀÂÄáàäâªÉÈÊËéèëêÍÌÏÎíìïîÓÒÖÔóòöôÚÙÛÜúùüûñÑ]+/',
					'/( ( +))/'),
			array(' ', ' '),
			trim($txt_busqueda));
/*
		foreach($arrayBusqueda as $key => $value){
			$cadena = mb_ereg_replace($arrayBusqueda[$key],$arrayReemplazo[$key], $cadena);
		}
*/
		//echo("<!-- $txt_busqueda -->");
		//Vamos a quitar todo rastro de tildes, y los guiones altos o bajos se pasan a espacio:
		$conTildes = array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª', 'É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê', 'Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î', 'Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô', 'Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û');
		$sinTildes = array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a', 'E', 'E', 'E', 'E', 'e', 'e', 'e', 'e', 'I', 'I', 'I', 'I', 'i', 'i', 'i', 'i', 'O', 'O', 'O', 'O', 'o', 'o', 'o', 'o', 'U', 'U', 'U', 'U', 'u', 'u', 'u', 'u');
		$txt_busqueda = str_replace($conTildes, $sinTildes, $txt_busqueda);
		$txt_busqueda = explode(' ', $txt_busqueda);
		ob_start();
		var_dump($txt_busqueda);
		$textoArrayBusqueda = ob_get_clean();
		/*echo("<!-- ");
		var_dump($txt_busqueda);
		echo("-->");*/
		if (count($txt_busqueda) > 0){
			
			//$words = array(array(), array());
			$words = array();
			//Pedro 11/Noviembre/2019 ==> Vamos a filtrar el array para quitar las palabras negativas:
			$txt_busqueda = array_filter($txt_busqueda, 'Blacklist_keyword::filterWord');
			foreach($txt_busqueda as $clave => $palabra){
				//Pedro 11/Noviembre/2019 ==> Para afinar más la búsqueda voy a buscar "sólo" palabras completas y sin puntos y/o comas
				$words[] = static::compoundSimpleSearchString($palabra, $aliasTabla, $campo, $gestionarPlural, $soloPalabras);
			}
			//Pedro 14/Septiembre/2020 ==> En configuración definimos si queremos las palabras con OR o con AND (valor por defecto)
			$separadorCondicional = ' AND ';
			//Ahora recorremos el array largo y después el corto:
			//Pedro 14/Septiembre/2020 ==> Tenemos que tener en cuenta que resultado sea una cadena independiente, por eso no e le pone el separador si está vacía:
			foreach($words as $keyWords => $wherePart){
				$resultado .= ( (empty($resultado)) ? '' : ' ' . $separadorCondicional . ' ') . $wherePart;
			}
			//FileSystem::log("-------------------------\n" . $resultado . "\n");
			
		}
		if (empty($resultado)){
			$retultado = ' ( ' . $resultado . ' ) ';
		}
		return($resultado);
	}
	
	//Pedro 31/Marzo/202 ==> Añadimos los campos $gestionarPlural = true, $caracterExtra = false.
		//$gestionarPlural ==> Añade la posibilidad de que la/s palabra/s puedan estar en plural
		//$soloPalabras ==> Busca palabras completas
	private static function compoundSimpleSearchString($string, $aliasTabla, $campo, $gestionarPlural = true, $soloPalabras = true){
		//Si la palabra termina en s, se la quitamos:
		//Vamos a ver la versión plural/singular de la palabra:
		//La última letra no es S, estamos en un singular, vamos a "pluralizarlo"
		$plural = $string;
		$nombreCampoTabla = '`' . $aliasTabla . '`.`' . $campo . '`';
		$sentence = '';
		//Pedro 14/Septiembre/2020 ==> Se añade la posibilidad de buscar por trozos dicho directamente desde configuración
		if ($soloPalabras && (!Shop::$configuracion->busqueda_por_trozos)) {
			$sentence = ' ( ' . $nombreCampoTabla . ' LIKE \'' . $string . '\' OR
						' . $nombreCampoTabla . ' LIKE \'% ' . $string . ' %\'' . ' OR 
						' . $nombreCampoTabla . ' LIKE \'% ' . $string . '\'' . ' OR 
						' . $nombreCampoTabla . ' LIKE \'' . $string . ' %\' ) ';
		}else{
			$sentence = ' ( ' . $nombreCampoTabla . ' LIKE \'%' . $string . '%\') ';
		}
		if ($gestionarPlural){
			//La frase puede que estuviese en singular ya de antemano, por eso quitamos 
			//Pasamos la palabra a plural en función del idioma actual
			$plural = Blacklist_keyword::getPlural($string);
			$sentence .= ' OR ' . static::compoundSimpleSearchString($plural, $aliasTabla, $campo, false, true);
			if (substr(strtolower($string), -1) == 's'){
				//Cuado me encuentre con una palabra que termine en S puede que sea un plural, lo "singularizamos"
				if (substr(strtolower($string), -3) == 'ces'){
					//En el caso de que termine en 'es' tenemos que añadir también la z
					$plural = substr($string, 0, strlen($string) - 3) . 'z';
					$sentence .= ' OR ' . static::compoundSimpleSearchString($plural, $aliasTabla, $campo, false, true);
				}else if (substr(strtolower($string), -2) == 'es'){
					//En el caso de que termine en 'es' tenemos que añadir también sin una letra menos
					$plural = substr($string, 0, strlen($string) - 2);
					$sentence .= ' OR ' . static::compoundSimpleSearchString($plural, $aliasTabla, $campo, false, true);
				}else{
					//En cualquier otro caso que termine en S, la quitamos
					$plural = substr($string, 0, strlen($string) - 1);
					$sentence .= ' OR ' . static::compoundSimpleSearchString($plural, $aliasTabla, $campo, false, true);
				}
			}
		}
		
		return( ' ( ' . $sentence . ' ) ');
	}
	
	function __construct($opciones){
		//A partir de ahora la búsqueda recibe un "OpcionesWidget"
		$this->busqueda_simple = '';
		$filtrado_actual = '';
		$this->autor = '';
		$this->editorial = '';
		$this->titulo = '';
		$this->isbn = '';
		$this->categoria = '';
		$this->ean = '';
		$this->nombre_coleccion = '';
		$this->nombreRealColeccion = '';
		if (is_a($opciones, 'OpcionesWidget')){
			$this->busqueda_simple = ($opciones->configuracion->busqueda_simple != NULL) ? $opciones->configuracion->busqueda_simple : $this->busqueda_simple;
			$this->autor = ($opciones->configuracion->autor != NULL) ? $opciones->configuracion->autor : $this->autor;
			$this->editorial = ($opciones->configuracion->editorial != NULL) ? $opciones->configuracion->editorial : $this->editorial;
			$this->titulo = ($opciones->configuracion->titulo != NULL) ? $opciones->configuracion->titulo : $this->titulo;
			$this->isbn = ($opciones->configuracion->isbn != NULL) ? $opciones->configuracion->isbn : $this->isbn;
			$this->categoria = ($opciones->configuracion->categoria != NULL) ? $opciones->configuracion->categoria : $this->categoria;
			$this->ean = ($opciones->configuracion->ean != NULL) ? $opciones->configuracion->ean : $this->ean;
			$this->nombre_coleccion = ($opciones->configuracion->nombre_coleccion != NULL) ? $opciones->configuracion->nombre_coleccion : $this->nombre_coleccion;
			$this->nombreRealColeccion = ($opciones->configuracion->nombreRealColeccion != NULL) ? $opciones->configuracion->nombreRealColeccion : $this->nombreRealColeccion;
			$filtrado_actual = ($opciones->configuracion->filtrado_actual != NULL) ? $opciones->configuracion->filtrado_actual : $filtrado_actual;			
		}
			
		$this->adaptarFiltrado($filtrado_actual, true); //==> Encargado de generar los filtrados de sesión o temporales del usuario
		$this->filtradoGlobal();						//==> Encargado de generar los filtrados globales de la web
		
		//Ahora, según los valores recibidos, vamos a hacer una cosa u otra
		if (trim($this->busqueda_simple) != ''){
			/*echo("<!--");
			var_dump($this->busqueda_simple);
			echo("-->");*/
			static::getWhereTabla($this->busqueda_simple);
			//Vamos a componer los datos seo
			$this->title_seo = traducir('Resultado de la búsqueda de') . ' ' . $this->busqueda_simple . ' ' . traducir('en') . ' ' . Shop::$empresa->nombre;
			$this->descripcion_seo = traducir('Estos son los productos encontrados en nuestra web con los términos de búsqueda ') . ' ' . $this->busqueda_simple;
			$this->keywords_seo = traducir('Resultado de la búsqueda de') . ' ' . $this->busqueda_simple . ' ' . traducir('en') . ' ' . Shop::$empresa->nombre;
			//Creamos la url de esta búsqueda
			$this->url = Shop::$configuracion->url . 'buscar/' . str_replace(' ', '-', $this->busqueda_simple);
		}else{
			$arrayBusqueda = array();
			//Vamos a crear la condición según el resto de parámetros
			if ($this->autor != ''){
				$arrayBusqueda['autor'] = $this->autor;
			}
			if ($this->editorial != ''){
				$arrayBusqueda['editorial'] = $this->editorial;
			}
			if ($this->titulo != ''){
				$arrayBusqueda['titulo'] = $this->titulo;
			}
			if ($this->isbn != ''){
				$arrayBusqueda['isbn'] = $this->isbn;
			}
			if ($this->ean != ""){
				$arrayBusqueda['ean'] = $this->ean;
			}
			if ($this->nombre_coleccion != ""){
				$arrayBusqueda['nombre_coleccion'] = $this->nombre_coleccion;
			}
			if ($this->nombreRealColeccion != ""){
				$arrayBusqueda['nombreRealColeccion'] = $this->nombreRealColeccion;
			}
			//pedro 19/Septiembre/2019 ==> Si no tenemos búsqueda aquí, entonces vamos a forzar una búsquda vacía
			if( count($arrayBusqueda) == 0){
				static::$whereSelect = ' `' .  Articulo::getAlias() . '`.`codigo` = 0 ';
			}else{
				static::getWhereTabla($arrayBusqueda);
			}
		}
		//---------------------------------------------------------------------------------------------
		//Inicializamos la consulta que dará pie a una lista de productos asociada:
		//---------------------------------------------------------------------------------------------
		//Vamos a obtener una lista de palabras clave negativas a quitar
		
		$this->nombreTablas = static::getNombreTabla();
		//Pedro 16/Octubre/2019 ==> Sacamos el count para contar los productos, estas selects pueden ser gigantescas
		$this->countCamposTabla = ' COUNT(`' . Articulo::getAlias() . '`.`codigo`) total '; 
		$this->camposTabla = static::getCampos(NULL);
		$this->whereTabla = static::$whereSelect;
		//FileSystem::log("La select:\nSELECT " . $this->camposTabla . "\n FROM " . $this->nombreTablas . "\n WHERE " . $this->whereTabla . "\n");
/*
		echo("<!--\n");
		echo("Select " . $this->camposTabla . " FROM " . $this->nombreTablas . " WHERE " . $this->whereTabla);
		echo("\n-->");
*/
		//Creamos el orden:
		$this->crea_orden('ORDER BY `' . static::getAlias() . '`.`articulo` DESC ');
		//Y la paginación
		$this->crea_paginacion();
	}

	public static function RemoteIndexProducts($data){
		$retorno = new stdClass();
		$updateAll = false;
		if (is_string($data)){
			$data = json_decode($data);
		}
		if (isset($data->updateAll)){
			$updateAll = $data->updateAll;
		}
		ob_start();
		$retorno->total = 0;
		$bd = new BaseDatos();
		if ($updateAll){
			echo("Tenemos que meter todos los productos como pendientes de indexar");
			//Si esta función no recibe este parámetro, se limita a reindexar el número de artículos que le toca
			//Pedro 28/Octubre/2019 ==> Ponemos TODOS los artículos Visibles como Pendientes de Indexar
			$sentencia_sql = 'UPDATE ' . Articulo::getNombreTablaSinAlias() . ' SET `pendiente_indexar` = 1 WHERE `no_web` = 0;';
			if ($bd->isConectado()){
				$bd->setConsultaSQL($sentencia_sql);
			}
		}
		
		self::indexProducts();
		//Hecho esto necesitamos saber cuantos artículos quedan por reindexar:
		$sentencia_sql = 'SELECT count(`codigo`) `total` FROM ' . Articulo::getNombreTablaSinAlias() . ' WHERE  ' . Articulo::getNombreTablaSinAlias() . '.`pendiente_indexar` = 1;';
		if ($bd->isConectado()){
			$bd->setConsultaSQL($sentencia_sql);
			$fila = $bd->getFila();
			$retorno->total = $fila['total'];
		}
		$msg = ob_get_clean();
		//$retorno->msg = $msg;
		return(json_encode($retorno));
	}

	public static function indexProducts($id = 0){
		//Por ahora voy a crear el índice completo de forma poco eficiente, ya optimizaré este proceso
		$camposFijos = array( array('articulo.nombre', 0), array('articulo.editorial', 1), array('articulo.autor', 2), array('articulo.ean', 3));
		$camposFijosIdioma = array();
		$camposVariables = array();
		$camposVariablesIdioma = array();
		//Según el tratamiento de los campos se hace una cosa u otra:
			//--Campos fijos, aquellos que no superan los 255
			//--Campos Variables, Aquellos que hay que partir
			//--Idioma => Campos que tienen traducción
		if (count($camposFijos) > 0){
			//Por ahora vamos a rellenar sólo este caso:
			//Necesito coger los idiomas activos:
			$idiomasActivos = Idioma::getActiveLanguajes(true);	//Pedro 28/Octubre/2019 ==> Cogemos sólo los códigos de los idiomas activos
			$bd = new BaseDatos();
			if ($bd->isConectado()){
				//Esto habrá que cambiarlo en el futuro para añadir campos de otras tablas
				foreach($idiomasActivos as $claveIdioma => $idioma){
					//Pedro 28/Mayo/2019
					//Lo primero es borrar de "search_index":
					$sentenciaBorrado = ' DELETE FROM `search_index` ';
					if ($id > 0){
						$sentenciaBorrado .= ' WHERE `articulo` = ' . $id . ' ';
					}else{
						$sentenciaBorrado .= ' WHERE `pendiente_indexar` = 1 ';
					}
					//Marina(27/Febrero/2020) este echo estaba sin comentar
					//echo("$sentenciaBorrado\n<br/>");
					$bd->setConsultaSQL($sentenciaBorrado);
					//Después del borrado vamos a coger de los artículos los que se hayan modificado
					$lista_campos = array();
					$lista_tablas = array('articulo' => true);
					foreach($camposFijos as $claveCampo => $campo){
						//Vamos a analizar si nos han pasado campos con su tabla o sólo los campos:
						//Modificado por Pedro el 05/Febrero/2020 ==> Vamos a quitar los espacios de cada campo:
						if (strpos($campo[0], '.') !== false){
							$partido = explode('.', $campo[0]);
							$lista_tablas[$partido[0]] = true;
							$lista_campos[] = 'TRIM(`' . $partido[0] . '`.`' . $partido[1] . '`)';
						}else{
							$lista_campos[] = 'TRIM(`articulo`.`' . $campo[0] . '`)';
						}
					}
					//Tenemos la lista de campos, vamos a hacer una select que nos dé esos campos para el o los artículos seleccionados:
					$lista_campos = implode($lista_campos, ', \' \', ');
					$sentencia = 'SELECT `codigo`, CONCAT( ' . $lista_campos . ') suma ';
					$sentencia .= ' FROM `articulo` ';
					foreach($lista_tablas as $nombreTabla => $dummy){
						if ($nombreTabla != 'articulo'){
							$sentencia .= ' LEFT JOIN `' . $nombreTabla . '` '
							. ' ON `' . $nombreTabla . '`.`articulo`= `articulo`.`codigo` ';
						}
					}

					if ($id > 0){
						$sentencia .= ' WHERE `articulo`.`codigo` = ' . $id . ';';
					}else{
						//Pedro 28/Mayo/2019
						//A partir de ahora sólo tocamos los índices que así estén definidos:
						$sentencia .= ' WHERE  `articulo`.`pendiente_indexar` = 1 LIMIT ' . static::BUFFER_INDEXADO . ' ;';	//Cuando se regeneren los índices vamos a tener un buffer
						//$sentencia .= ' WHERE  `articulo`.`pendiente_indexar` = 1;';	//Sin buffer de manera temporal
					}
					//Marina (27/Febrero/2020) este echo estaba sin comentar
					//echo("$sentencia\n");
					if ( $bd->setConsultaSQL($sentencia)) {
						//Inicializamos varias variables auxiliares
						$listaInsert = '';
						$sentenciaInsert = '';
						$lista_articulos = array();
						while($fila = $bd->getFila()){
							$codigoArticulo = $fila['codigo'];
							//Pedro 05/Febrero/2020 ==> vamos a limpiar la cadena completamente para dejar sólo números y letras
							//$Pedro 20/Julio/2020 ==> Estamos teniendo problemas con el carácter "¡" (exclamación). Vamos a aseguranos primero de que la cadena está en utf8_decode
							//$cadena = iconv('ISO-8859-1', 'UTF-8', trim($fila['suma']));
							$arrayBusqueda = array('[^a-zA-Z0-9 ÁÀÂÄáàäâªÉÈÊËéèëêÍÌÏÎíìïîÓÒÖÔóòöôÚÙÛÜúùüûÑñ]+',
										'( ( +))');
							$arrayReemplazo = array(' ', ' ');
							$cadena = $fila['suma'];
							/*$cadena = preg_replace(
								array('/[^a-zA-Z0-9 ÁÀÂÄáàäâªÉÈÊËéèëêÍÌÏÎíìïîÓÒÖÔóòöôÚÙÛÜúùüûÑñ]+/',
										'/( ( +))/'),
								array(' ', ' '),
								$fila['suma']);*/
							foreach($arrayBusqueda as $key => $value){
								$cadena = mb_ereg_replace($arrayBusqueda[$key],$arrayReemplazo[$key], $cadena);
							}
							//Vamos a quitar todo rastro de tildes, y los guiones altos o bajos se pasan a espacio:
							$conTildes = array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª', 'É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê', 'Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î', 'Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô', 'Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û');
							$sinTildes = array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a', 'E', 'E', 'E', 'E', 'e', 'e', 'e', 'e', 'I', 'I', 'I', 'I', 'i', 'i', 'i', 'i', 'O', 'O', 'O', 'O', 'o', 'o', 'o', 'o', 'U', 'U', 'U', 'U', 'u', 'u', 'u', 'u');
							$cadena = str_replace($conTildes, $sinTildes, $cadena);
							$cadena = addslashes($cadena);
							$lista_articulos[] = $codigoArticulo;
							$listaInsert .= (($listaInsert != '') ? ', ' : '') . "\n" . ' ( \''. $codigoArticulo . '\', \'' . $cadena . '\', \'' . $idioma . '\' ) ';
						}
						if ($listaInsert != ''){
							$sentenciaInsert = 'INSERT INTO `search_index` ( `articulo`, `valor`, `idioma`) '
								. ' VALUES ' . $listaInsert . "; \n";
							//echo("$sentenciaInsert<br>\n");
						}
						//Ejecuto esta sentencia para coger los datos de los productos a insertar:
					
						//"Si ejecuto "sentenciaProducto tengo una macro sentencia que me llenará la tabla:
						if ($sentenciaInsert != ''){
							//En este caso tengo que eliminar de la tabla toda referencia del producto o productos:
							$bd = new BaseDatos();
							if ($bd->isConectado()) {
								//ejecutamos la insert:
								//echo("$sentenciaInsert\n");
								$bd->setConsultaSQL($sentenciaInsert);
								//echo($sentenciaInsert);
							}
						}
					}
				}
			}
		}
		if (count($camposFijosIdioma) > 0){
			
		}
		if (count($camposVariables) > 0){
			
		}
		if (count($camposVariablesIdioma) > 0){
			
		}
		
	}
	
	function __destruct(){
		
	}
}
?>