<?php

class SuperRangoEnvio  extends Objeto{
    public static $campos_tabla = array();
    public static $alias = '';
    public static $nombreTabla = '';
    public static $camposSelect = '';
    public static $whereSelect = '';
    public static $publicFieldList = array();


    public $codigo = 0;
    public $tipo_envio_cliente = 0;
    public $rango_inferior = 0;
    public $rango_superior = 0;
    public $importe = 0;

	public static function getNombreTabla($soloPrincipal = NULL, $tablasOrigen = NULL){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		$consulta = ' `' . static::$nombreTabla . '` as `' .  static::getAlias() . '` ';
		//Sólo asignamos el nombre de la tabla si no nos piden más parámetros
		if ($soloPrincipal == NULL){
			static::$nombreTabla = $consulta;
		}

		return($consulta);
	}

    function __construct($codigo = 0) {
        include('comunes/globals.php');
        $sentencia_sql = 'SELECT codigo, tipo_envio_cliente, rango_inferior, rango_superior, importe '
                . 'FROM rango_envio '
                . 'WHERE codigo = '. $codigo;
        if ($conexionBD) {
            if ($resultado = mysqli_query($conexionBD, $sentencia_sql)) {
                if ($fila = mysqli_fetch_array($resultado)) {
                    $this->codigo = $fila['codigo'];
                    $this->tipo_envio_cliente = $fila['tipo_envio_cliente'];
                    $this->rango_inferior = $fila['rango_inferior'];
                    $this->rango_superior = $fila['rango_superior'];
                    $this->importe = $fila['importe'];
                }
            }
        }
    }

    function __destruct() {
        unset($this->codigo);
        unset($this->tipo_envio_cliente);
        unset($this->rango_inferior);
        unset($this->rango_superior);
        unset($this->importe);
    }

    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }

}

?>