<?php

/*
  Clase SuperGetter
  Clase encargada de recoger los métodos get y post
  @version 1.0
 */

class SuperGetter {
	private static $clean = false;
    //Constructor y destructor
    public function __construct() {
		
    }

    public function __destruct() {
        
    }
	
	//Función encargada de recibir una variable recibida vía http (get o post):
	public static function get($variableName = '', $defaultValue = NULL, $method = ''){
		$retorno = $defaultValue;
		if (!self::$clean){
			//Si nos mandan una variable, la recogemos sólo a ella:
			if ($variableName != ''){
				//Hay que ver si la variable ha llegado por get o por post (siempre y cuandno hayan especificado el método:
				if ($method == ''){
					//Hay que comprobar si la variable está seteada en GET o en POST:
					if (static::isInGet($variableName)){
						$retorno = $_GET[$variableName];
					}else if (static::isInPost($variableName)){
						$retorno = $_POST[$variableName];
					}
				}else{
					$method = strtoupper($method);
					if ( ($method == 'GET') && (static::isInGet($variableName)) ){
						$retorno = $_GET[$variableName];
					}else if ( ($method == 'POST') && (static::isInPost($variableName)) ){
						$retorno = $_POST[$variableName];
					}
				}
			}else{
				$variableList = file_get_contents('php://input');
				$retorno = $variableList;
			}
		}
		return($retorno);
	}
	
	public static function getJson(){
		$return = '';
		if (!self::$clean){
			$return = file_get_contents('php://input');
		}
		return($return);
	}
	
	public static function isInGet($variableName){
		$retorno = false;
		if (!self::$clean){
			if (isset($_GET[$variableName])){
				$retorno = true;
			}
		}
		return($retorno);
	}
	public static function isInPost($variableName){
		$retorno = false;
		if (!self::$clean){
			if (isset($_POST[$variableName])){
				$retorno = true;
			}
		}
		return($retorno);
	}
	
	//Funciones que uso para concatenar dos strings sin repetir la parte que se solape
	private static function findOverlap($str1, $str2){
		$return = array();
		$sl1 = strlen($str1);
		$sl2 = strlen($str2);
		$max = ($sl1 > $sl2)? $sl2 : $sl1;
		$i=1;
		while($i <= $max){
			$s1 = substr($str1, -$i);
			$s2 = substr($str2, 0, $i);
			if($s1 == $s2){
				$return[] = $s1;
			}
			$i++;
		}
		if(empty($return)){
			$return = false;
		}
		return($return);
	}

	public static function replaceOverlap($str1, $str2, $length = "long"){
		if($overlap = static::findOverlap($str1, $str2)){
			switch($length){
				case "short":
					$overlap = $overlap[0];
				break;
				case "long":
				default:
					$overlap = $overlap[count($overlap)-1];
				break;
			}     
			$str1 = substr($str1, 0, -strlen($overlap));
			$str2 = substr($str2, strlen($overlap));
			return $str1.$overlap.$str2;
		}
		return false;
	}
	
	public static function cleanReceived(){
		foreach($_POST as $key => $value){
			unset($_POST[$key]);
		}
		unset($_POST);
		foreach($_GET as $key => $value){
			unset($_GET[$key]);
		}
		unset($_GET);
		self::$clean = true;
	}

	public static function getList($metodo = '', $blacklist = array(), $discardEmtpyValues = true){
		$return = array();
		//Pedro 02/Diciembre/2019 ==> Vamos a utilizar un único array que recorrer
		$checkArray = array();
		if($metodo == '' || strtoupper($metodo) == 'GET'){
			$checkArray = array_merge($checkArray, $_GET);
		} 

		if($metodo == '' || strtoupper($metodo) == 'POST'){
			$checkArray = array_merge($checkArray, $_POST);
		}
		if (count($checkArray) > 0){
			foreach($checkArray as $key => $value){
				//Vamos a determinar si una variable está vacía bajo estas condiciones:
				if (is_array($value)){
					$notEmpty = !(count($value) == 0);
				}else{
					$notEmpty = !(trim($value) == '');
				}
				//Esta condición se ha hecho así para que compla cuando:
					//El valor no esté en una lista negra Y
					//El valor no esté vacío cuando se haya activado el "discardEmtpyValues"
					//El valor vacío puede ser un array tb
				if( (!in_array($key, $blacklist)) && ((!$discardEmtpyValues) || $notEmpty) ){
					$return[$key] = $value;
				}
			}
		}
		return($return);
	}
}
