<?php

	//Con este clase vamos a gestionar las opciones que vamos a utilizar en las funciones
class SuperObOptions {

    function __construct($object = NULl) {
		$standardObject = $object;
		if (is_a($object, 'OpcionesWidget')){
			//$standardObject = json_decode(json_encode($object->configuracion));
			$standardObject = (object) $object->configuracion;
		}else if (is_array($object)){
			$standardObject = (object) $object;
		}
		$this->initThis($standardObject);
    }

	private function initThis($object){
		if (is_object($object)){
			$params = get_object_vars($object);
			foreach($params as $clave => $valor){
				$this->{$clave} = $valor;
			}
		}
	}
	
    function __set($name, $value) {
        $this->$name = $value;
    }

    function __get($name) {
        $retorno = NULL;
        if (isset($this->$name)) {
            $retorno = $this->$name;
        }
        return($retorno);
    }

	public function getDefaultValue($name, $defaultValue = NULL){
		if (isset($this->$name)) {
            $retorno = $this->$name;
        }else{
			$retorno = $defaultValue;
		}
		return($retorno);
	}
	
	public static function sGetDefaultValue($object, $name, $defaultValue){
		if (isset($object->$name)) {
            $retorno = $object->$name;
        }else{
			$retorno = $defaultValue;
		}
		return($retorno);
	}
	
	//Esta función la dejo porque es una fucking obra maestra, resulta que con la función de json_encode obtengo más o menos lo mismo
	//la única diferencia es que los arrays asociativos los convierte en objetos
	public static function sToJs($object){
		//Recibimos un objeto y lo pasamos a formato javascript:
		// {variable:'valor'}
		$parametros = array();
		$resultado = '';
		//En los "opcionesSlider" se estaba mandando todo como string, y los strings vienen ya con las comillas. Vamos a dejar todo eso limpio:
		if (is_string($object)){
			//Empezamos quitando comillas simples
			$object = str_replace('\'', '', $object);
			$object = ($object == 'false') ? false : $object;
			$object = ($object == 'true') ? true : $object;
		}
		if (is_object($object)){
			//Si es un objeto sacamos los valores en formato array
			$parametros = get_object_vars($object);
			$resultado = '{';
			$coma = '';
			foreach($parametros as $clave => $valor){
				$resultado .= $coma . $clave . ' : ' . ObOptions::sToJs($valor);
				$coma = ',';
			}
			$resultado .= "}\n";
		}else if (is_array($object)){
			//Si es un array, son los propios parámetros
			$parametros = $object;
			$resultado = '[';
			$coma = '';
			foreach($parametros as $clave => $valor){
				$resultado .= $coma . ObOptions::sToJs($valor);
				$coma = ',';
			}
			$resultado .= "]\n";
		}else if(is_string($object)){
			//Va con las comillas
			$resultado = '\'' . $object . '\'';
		}else if(is_null($object)){
			$resultado = '\'null\'';
		}else if (is_bool($object)){
			$resultado = ($object)? 'true' : 'false';
		}else{
			$resultado = $object;
		}
		return($resultado);
	}
	
	public function toArray(){
		$return = get_object_vars($this);
		return($return);
	}
}

?>