<?php
/*
	Clase SuperSections para las secciones de la web
	@version 1.0
*/
//Esta clase utiliza el compresor/minificador

use PHPWee\CssMin;
use PHPWee\JsMin;
use PHPWee\HtmlMin;


class SuperPHPWee extends WSMinificator{
	//TODO => Si se modifica la sesión hay que limpiar los "media"
	public static function compress($listFiles = array(), $fileName = ''){

		require_once(_WS_LIB_DIR_ . 'phpwee/src/CssMin/CssMin.php');
		require_once(_WS_LIB_DIR_ . 'phpwee/src/HtmlMin/HtmlMin.php');
		require_once(_WS_LIB_DIR_ . 'phpwee/src/JsMin/JsMin.php');

		//Vamos a convertir los ficheros:
		$extension = pathinfo($fileName, PATHINFO_EXTENSION);
		$finalPath = _WS_DYNAMIC_DIR_ . 'media/' . $extension . '/';
		$resultado = '';
		
		foreach($listFiles->list as $clave => $filetime){
			//$path = _WS_DIR_ . _WS_THEMES_DIR_ . _WS_THEME_DIR_ . _WS_THEME_HTML_DIR_ . $clave;
			//Pedro 04/Mayo/2020 ==> El fichero puede estar en cualquier sitio así que vamos a obtener su ruta del tema:
			$path = Theme::findFile(basename($clave));
			$contenido = file_get_contents($path);
			
			if ($extextension = 'js'){
				$resultado .= JsMin::minify($contenido);
			}else{
				$resultado .= CssMin::minify($contenido);
			}

		}

		$resultado = static::fixWSPaths($resultado);
		if ($file = fopen($finalPath . $fileName, 'w')){
			fwrite($file, $imports . $resultado);
			fclose($file);
		}
	}
}
