<?php
	//Antes de arrancar el core de webStore vamos a inicializar las variables locales que indicarán qué web vamos a mostrar con este index.
	// Es decir, vamos a tener preparado en el motor de webStore una constante en la que especificar que plantilla cogemos:
	//Pedro 05/Mayo/2020 ==> OJO, vamos a tener en cuenta que estemos en modo mantenimiento:
	if (file_exists('blocked')){
		include_once('mantenimiento/local.php');	// ==> Toda la configuración local se hará relativa a la carpeta "mantenimiento"
	}else{
		include_once('local.php');	// ==> Lo hacemos con un include para no tener que editar el index en cada cliente (Pedro 07/Febrero/2019)
	}
	
	
	//Nos aseguramos de que SIEMPRE exista un "core_path"
	if (!defined('_WS_CORE_PATH')){
		define('_WS_CORE_PATH', '');	//Esta variable SÓLO se usa para poder hacer el include de webStore sin tener que tocar el index.php.
										//	Existe otra variable que es "_WS_CORE_DIR_" que contiene la ruta absoluta interna al core de webStore
	}
	//Arrancamos el core de webStore
	include(_WS_CORE_PATH . 'core/initWebStore.php');
	//FileSystem::log("Iniciado webStore");
	error_reporting(E_ALL);	// Esto en el futuro debe desaparecer

	//Vamos a cargar el control de secciones:
	//Álvaro 050219 Tarea 5170: Ahora, en vez de hacer un include de sectioncontrol.php, vamos ahora a llamar a esa funcion estática de sections.php
	//include_once(_WS_CORE_DIR_ . 'sectionControl.php');
	Sections::sectionControl();	//Obsérvese que para que esto tenga sentido se ha cargado el core de webStore, si no, no podríamos hacer referencia a ninguna clase
	//FileSystem::log("Controladas las secciones");
	//Una vez que se ha controlado todo esto, vamos a mostrar el contenido, pero ojo, si la web hay que recargarla lo hacemos sin más
	//Si hay que recargar la web, lo hacemos aquí
	if (Sesion::getReloadPage()) {
		//FileSystem::log("Hay que recargar la página");
		//header('location:' . $url_sin_parametros); ==> la web se va a recargar a si misma
		Sesion::reloadPage($_SERVER["REQUEST_URI"]);
	}else{
		//FileSystem::log("No hay que recargar la página");
		//Si la sección es completa la cargamos directamente:
		$completa = Sections::getAttr('completa');
		if ($completa){
			//FileSystem::log("Sección completa, mostramos el contenido");
			Theme::showContent();
		}else{
			//FileSystem::log("Sección NO completa");
			//cargamos el fichero de la sección, según la sección, la plantilla puede ser diferente
			$ficheroPlantilla = Sections::getAttr('plantilla');
			if ( ($ficheroPlantilla != NULL) && ($ficheroPlantilla != '') ){
				//FileSystem::log("Cargamos la plantilla {$ficheroPlantilla}");
				Theme::include_file($ficheroPlantilla);
			}
		}

		$absoluta = Sections::getAttr('absoluta');
		//Si la sección no es absoluta mostramos lo siguiente:
		if (!$absoluta){
			//FileSystem::log("Scripts necesarios en webStore");
		//WebStore tiene algunos Scripts que son independientes del tema, vienen SIEMPRE de serie:
		
		//Es muy importante programar en javascript que si se ha cargado la web se lance el evento de WSLE (Web Store Load Event
?>
<script>
var auxFunc = window.onload;
auxFunc = (auxFunc == null) ? function(){} : auxFunc;
window.onload = function() {auxFunc(); var event = new Event('WSLE'); document.dispatchEvent(event); };
</script>
<?php
			//Pedro 19/Junio/2019 ==> Hacemos que la función "remote request" sea diferente en cada sesión
			//Primero llamamos a la función:
			 RemoteRequest::WS_data_update();
		}
		//Para asegurarnos de que se guarde en la sesión todo, hacemos un commit
		//FileSystem::log("Commit de sesión");
		Sesion::commit();
	}

//Esta función da error y no tengo muy claro pa que se usa, pa no quitarla voy a hacer q se ejecute sólo si hay buffer
/*while (ob_get_level() > 0){
	ob_end_flush();
}*/

//Lo último es desconectarnos de la base de datos
//FileSystem::log("Cerramos conexión con la base de datos y los estudios centrales");
//BaseDatos::closeConexion();	//Esto no se puede hacer aquí, lo hace el propio "View"
