<?php
//---------------------------------------------------------------------------------------------------------
// 26/Agosto/2019 ==> Exjemplo básico de cómo se crea un módulo
//---------------------------------------------------------------------------------------------------------
//Los módulos heredan los atributos de la clase Module:
/*	$templateFile = '';
	$loadedModules = array();
	$modulesList = array();
	$options = NULL;
	$data_update = '';
*/

class Enlaces_de_articulo extends Module{
	//Definimos la lista de acciones que ejecutará este módulo
	protected static $actionList = array('');

	//Función que instala el módulo
	public function install(){
		//Es necesario crear una tabla con este widget:
		$sqlCreate = 'CREATE TABLE `enlaces_articulo` ( 
			  `codigo` BIGINT NOT NULL , 
			  `articulo` BIGINT NOT NULL , 
			  `descripcion` VARCHAR(40) NOT NULL DEFAULT \'\', 
			  `enlace` VARCHAR(250) NOT NULL DEFAULT \'\' , 
			  PRIMARY KEY (`codigo`), INDEX (`articulo`)) ENGINE = MyISAM;';
		
		//TODO: hay que ejecutar la consulta mysql:
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			//trazas:
			$bd->setConsultaSQL($sqlCreate);
		}
	}
	
	//Función que desinstala el módulo
	public function uninstall(){
		$sqlCreate = 'DROP TABLE  IF EXISTS `enlaces_articulo`;';
		//TODO: hay que ejecutar la consulta mysql:
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			//trazas:
			$bd->setConsultaSQL($sqlCreate);
		}
		
	}
	
	
	//constructor:
	public function __construct() {
		require_once(_WS_MODULES_DIR_ . strtolower(get_class($this)) . '/lib/enlaces_articulo.php');
	}
	
	//Aquí vienen ahora las funciones que se encargan de añadir funciones a los eventos de webStore
	
	//Esta función es la encargada de ejecutar del módulo lo que sea necesario:
	public function execute(){
		ob_start();
		$opciones_recibidas = new ObOptions($this->getModuleOptions());	//Recogemos las opciones que nos puedan haber mandado
		//$variable = $opciones_recibidas->getDefaultValue('nombre_opcion', valor_x_defecto);
		$articulo = $opciones_recibidas->getDefaultValue('articulo', NULL);
		$options = new stdClass();
		//Aquí metemos la lógica necesaria para inicializar la vista o ejecutar otra vista
		$options->enlaces = Enlaces_articulo::getList($articulo);
		
		//$options->name = value;
		//Lo último es asignar las opciones a la vista
		$this->setViewOptions($options);
		$texto = ob_get_clean();
		FileSystem::log($texto);
	}


	
}