<?php
//---------------------------------------------------------------------------------------------------------
// 08/Noviembre/2018 ==> Módulo encargado de los pagos a redsys
//---------------------------------------------------------------------------------------------------------
//Los módulos heredan los atributos de la clase Module:
/*	$templateFile = '';
	$loadedModules = array();
	$modulesList = array();
	$options = NULL;
	$data_update = '';
*/

class Paycomet extends Module{
	//Definimos la lista de acciones que ejecutará este módulo
	protected static $actionList = array('');
	//Variables que necesitamos:
	private $merchantCode = 'tanb6cf3';
	private $password  = 'gdqzet7arfw5736sdcds';
	private $terminal = '16474';
	private $jetID = 'oQfZvHuGqBmh1F98aWynKxISDdzbAC7s';
	//URLs a las que dirigir
	private $urlOK = '/';
	private $urlKO = '/';
	//Función que instala el módulo
	public function install(){
		
	}
	
	//Función que desinstala el módulo
	public function uninstall(){
		
	}
	
	
	//constructor:
	public function __construct() {
		//Vamos a inicializar algunas variables
		$this->urlOK = Shop::$configuracion->url . 'finalizar_compra/';
		$this->urlKO = Shop::$configuracion->url . 'cesta/';
		
	}
	
	//Aquí vienen ahora las funciones que se encargan de añadir funciones a los eventos de webStore
	
	//Esta función es la encargada de ejecutar del módulo lo que sea necesario:
	public function execute(){
		$opciones_recibidas = new ObOptions($this->getModuleOptions());	//Recogemos las opciones que nos puedan haber mandado

		//Cargamos la librería de paycomet
		require_once(_WS_MODULES_DIR_ . strtolower(get_class($this)) . '/lib/paycomet_bankstore.php');
		
		$chequear_pago = $opciones_recibidas->getDefaultValue('chequear_pago', false);
		if ($chequear_pago){
			$options = $this->checkPago($opciones_recibidas);
		}else{
			$options = $this->iniciarCobro();
		}
		//Lo último es asignar las opciones a la vista
		$this->setViewOptions($options);
	}	

	private function iniciarCobro(){
		$cart = CabeceraCesta::getCart();
		//Generamos un ID para este pedido
		$cart->incrementarNumeroPedido();
		$this->urlOK .= $cart->numero_pedido;
		$options = new stdClass();
		//Como es para las pruebas no voy a comprobar nada
		$pasarela = $cart->pasarela(1); //Por ahora, con esto comprobamos que el pedido se pague por pasarela
		$options->pasarela = $pasarela;
		//Si no hay pasarela no seguimos:
		if ($pasarela){
			$paycomet = new Paycomet_Bankstore($this->merchantCode, $this->terminal, $this->password);
			//Vamos a obtener la URL para este pago:
			$retorno = $paycomet->ExecutePurchaseUrl(
					$cart->numero_pedido, 										//$transreference, 
					number_format($cart->importe + $cart->g_envio, 2, '', ''), 	//$amount
					'EUR',														//$currency,
					'ES',														//$lang = "ES", 
					'Pedido a ' . Shop::$empresa->nombre,						//$description = false, 
					true,														//$secure3d = false, 
					NULL,														//$scoring = null, 
					$this->urlOK,												//$urlOk = null, 
					$this->urlKO												//$urlKo = null, 
					/*
					//Resto de parámetros que quitamos por ahora
					$merchant_data = null, 
					$merchant_description = null, 
					$sca_exception = null, 
					$trx_type = null, 
					$scrow_targets = null*/
				);
			//var_dump($retorno);
			$url = '';
			if (is_object($retorno)){
				$options->error = $retorno->DS_ERROR_ID;
				$options->url = $retorno->URL_REDIRECT;
				$options->resultado = $retorno->RESULT;
				$options->txtError = $this->getError($options->error);
			}

			//Vamos a componer las opciones:
			//$options->merchantCode = $this->merchantCode;
			//$options->password = $this->password;
			//$options->terminal = $this->terminal;
			//Seguimios:
			//https://docs.paycomet.com/es/integracion/get-docs
		}
		return($options);
	}
	
	private function getError($code){
		$txtError = '';
		require_once( _WS_MODULES_DIR_ . strtolower(get_class($this)) . '/lib/paycomet_error.php');
		if (isset($errArr) && isset($errArr[$code])){
			$txtError = $errArr[$code];
		}
		return($txtError);
	}
	

	private function checkPago($opcionesRecibidas){
		//En paycomet no hay resultado que mostrar
		$templateFile = '';
		$options = new stdClass();
		$opcionesRecibidas = new ObOptions($opcionesRecibidas);
		$Order =  $opcionesRecibidas->getDefaultValue('Order', 0);
		$Response = $opcionesRecibidas->getDefaultValue('Response', 'KO');
		$ErrorID = $opcionesRecibidas->getDefaultValue('ErrorID', 0);
		$ErrorDescription = $opcionesRecibidas->getDefaultValue('ErrorDescription', 0);
		$Amount = $opcionesRecibidas->getDefaultValue('Amount', 0);
		$AccountCode = $opcionesRecibidas->getDefaultValue('AccountCode', 0);
		$TpvID = $opcionesRecibidas->getDefaultValue('TpvID', 0);
		//Vamos a capturar la salida:
		ob_start();
		//Para empezar comprobamos resultado, accountcode y tpvid

		if ( (strtoupper($Response) == 'OK') && ($this->merchantCode == $AccountCode) && ($this->terminal == $TpvID ) && ($Order > 0) ){
			//Vamos a cargar el pedido
			$cart = new CabeceraCesta(array(
				'numero_pedido' => intval($Order),
				'fusionarCesta' => false	//EXTREMADAMENTE IMPORTANTE, ESTE PROCESO SE EJECUTA SIN USUARIO Y LA CESTA TIENE USUARIO. HAY QUE EVITAR QUE INTENTE FUSIONAR
			));
			if ($cart->codigo > 0){
				//Tenemos un pedido, vamos a er si el importe coincide
				if (number_format($cart->importe + $cart->g_envio, 2, '', '') == $Amount){
					//Tenemos pedido!!!!
					$ready = $cart->readyToFinish();
					echo("Ready es : {$ready}<br/>");
                    if ($ready >= 200) {
                        $pedido = $cart->finish();
                        //Vamos a dar el pedido por pagado:
                        if ($pedido != null) {
                            $pedido->pagado(); ?>
							----------------------------------------------------------------------------------------------------------------------------------------
							----------------------------------------------------------------------------------------------------------------------------------------
																	CORRECTO, PEDIDO FINALIZADO CON CÓDIGO <?=$pedido->codigo; ?>
							----------------------------------------------------------------------------------------------------------------------------------------
							----------------------------------------------------------------------------------------------------------------------------------------
							<?php
                        } else {
                            ?>
							----------------------------------------------------------------------------------------------------------------------------------------
							----------------------------------------------------------------------------------------------------------------------------------------
																INCORRECTO, Error al crear el pedido
							----------------------------------------------------------------------------------------------------------------------------------------
							----------------------------------------------------------------------------------------------------------------------------------------
							<?php
                        }
                    }else{
						?>
						----------------------------------------------------------------------------------------------------------------------------------------
						----------------------------------------------------------------------------------------------------------------------------------------
															INCORRECTO, PEDIDO NO FINALIZADO CON ERROR <?=$ready;?>
						----------------------------------------------------------------------------------------------------------------------------------------
						----------------------------------------------------------------------------------------------------------------------------------------
						<?php
					}
				}else{
					?>
					----------------------------------------------------------------------------------------------------------------------------------------
					----------------------------------------------------------------------------------------------------------------------------------------
														EL IMPORTE RECIBIDO NO COINCIDE CON EL IMPORTE REAL DEL PEDIDO
					----------------------------------------------------------------------------------------------------------------------------------------
					----------------------------------------------------------------------------------------------------------------------------------------
					<?php	
				}
			}else{
				?>
				----------------------------------------------------------------------------------------------------------------------------------------
				----------------------------------------------------------------------------------------------------------------------------------------
													EL PEDIDO RECIBIDO NO EXISTE EN LA BASE DE DATOS
				----------------------------------------------------------------------------------------------------------------------------------------
				----------------------------------------------------------------------------------------------------------------------------------------
				<?php	
			}
		}else{
			?>
			----------------------------------------------------------------------------------------------------------------------------------------
			----------------------------------------------------------------------------------------------------------------------------------------
										EL PEDIDO NO SE HA PODIDO FINALIZAR PORQUE LOS DATOS RECIBIDOS NO COINCIDEN
			----------------------------------------------------------------------------------------------------------------------------------------
			----------------------------------------------------------------------------------------------------------------------------------------
			<?php
			echo("{$ErrorId} - {$ErrorDescription}\n");
		}
		
		//Enviamos un email a la empresa con los datos técnicos de la pasarela
		$texto = ob_get_clean();
		echo($texto);
		$this->setTemplateFile($templateFile);
		return($options);
	}

}