<?php
/*
	Clase SuperBanner
	// Editado por Tomás añadido el campo target.
	//Editado por Pedro para añadir la clase BaseDatos
*/

class Url_fotos_articulo extends Objeto{
	public static $campos_tabla = array();
	public static $camposSelect = '';
	public static $whereSelect = '';
	//public static $nombreTabla = 'banner';
	public static $nombreTabla = '';
	//public static $alias = 'banner';
	public static $alias = '';
	public static $publicFieldList = array();
	
	public $codigo = 0;
	public $articulo = 0;
	public $objeto_articulo = NULL;
	public $url = '';

	
	public static function getCampos(){
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Una vez que tenemos el nombre de la tabla, vamos a obtener los campos de la misma y los nombres para la selec
		if (static::$nombreTabla != ''){
			//include('comunes/diccionario/diccionario.php');
			//static::$campos_tabla = BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'};
			static::$campos_tabla = BaseDatos::dameCampos(static::$nombreTabla);
			//static::$camposSelect = BaseDatos::dameCamposAlias(BaseDatos::$dictionary->{static::$nombreTabla . 'Campos'}, static::getAlias()) . ' ';
			static::$camposSelect = BaseDatos::dameCamposAlias(static::$nombreTabla) . ' ';
		}
		return(static::$camposSelect);
	}
	
	public static function getNombreTabla(){
		$idioma = Idioma::getCurrentLanguaje(true);
		//Incluimos los globals para coger el valor del idioma:
		//include('comunes/globals.php');
		static::$nombreTabla = strtolower(get_called_class());
		static::getTablaRelacionada();
		//Vamos a simplificar, cogemos el nombre de la tabla usando la función de la clase padre:
		static::$nombreTabla = static::$nombreTabla . ' `' .  static::getAlias() . '`  ';
		return(static::$nombreTabla);
	}  
	
	public static function getWhereTabla(){
		$argumentos = func_get_args();
		$articulo = isset($argumentos[0]) ? $argumentos[0] : NULL;
		$limitar = isset($argumentos[1]) ? $argumentos[1] : true;
		$codigo = isset($argumentos[2]) ? $argumentos[2] : NULL;
		
		//include('comunes/globals.php');
		static::$whereSelect = '';
		if ($articulo != NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`articulo` = "' . $articulo . '" ';
		}
		if ($codigo != NULL) {
			static::$whereSelect .= ' `' . static::getAlias() . '`.`codigo` = "' . $codigo . '" ';
		}
		if ($limitar){
			static::$whereSelect .= ' LIMIT 1 ';
		}
		return(static::$whereSelect);
	}

	
	
	function __construct($opciones){
		//08/Mayo/2019 ==> Hay que inicualizar los campos en la lista de campos de la tabla sólo si no está inicializada:
		if (empty(static::$publicFieldList)){
			$this->initPublicFields();
		}
		//include('comunes/globals.php');
		$filaUrl_fotos_articulo = NULL;
		$articulo = NULL;
		$codigo = NULL;
		$opciones = new ObOptions($opciones);
		$articulo = $opciones->getDefaultValue('articulo'. NULL);
		$filaUrl_fotos_articulo = $opciones->getDefaultValue('filaUrl_fotos_articulo'. NULL);
		$codigo = $opciones->getDefaultValue('codigo'. NULL);

		
		$fila = NULL;
		//Si no nos han pasado una select y nos han pasado un artículo, cogemos la misma
		if (is_a($articulo, 'Articulo')) {
			$this->objeto_articulo = $articulo;
			if ($filaUrl_fotos_articulo == NULL){
                $sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . '
								WHERE ' . static::getWhereTabla($articulo->codigo, true, $codigo);
				//echo($sentencia_sql);
                $bd = new BaseDatos();
                if ($bd->isConectado()) {
                    $bd->setConsultaSQL($sentencia_sql);
                    $fila = $bd->getFila();
                }
            }
		}else{
			$fila = $filaUrl_fotos_articulo;
		}
		if ($fila != NULL){
			$this->extractData($fila);
		}
	}
	
	private function extractData($fila){
        $this->codigo = $this->getProp($fila, 'codigo');
		$this->articulo = $this->getProp($fila, 'articulo');
		$this->objeto_articulo = (is_a($this->objeto_articulo, 'Articulo')) ? $this->objeto_articulo : new Articulo($this->codigo);
        $this->url = $this->getProp($fila, 'url');
    }
	
	function __destruct() {
        unset($this->codigo);
        unset($this->articulo);
        unset($this->objeto_articulo);
        unset($this->url);
    }
	
	/*public function initPublicFields(){	//El banner tiene todos sus campos públicos
		//En esta función se deben de poner los nombres de los campos en la tabla
		//Sólo pondremos aquellos campos a los que les vamos a dar acceso al usuario
		$publicFieldList = array();
		$publicFieldList[] = 'posicion';
		$publicFieldList[] = 'orden';
		$publicFieldList[] = 'url';
		$publicFieldList[] = 'ruta';
		$publicFieldList[] = 'titulo';
		$publicFieldList[] = 'imagen';
		$publicFieldList[] = 'condicion';
		$publicFieldList[] = 'target';
		static::$publicFieldList = $publicFieldList;
	}*/

	
    public function getJSON() {
        $prop = get_object_vars($this);
        $resp = '{ ';
        foreach ($prop as $key => $value) {
            if (!is_object($value)) {
                $value = (string) $value;
                if ($this->flag_utf8) {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode($value)) . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode(htmlspecialchars_decode(utf8_encode($value))) . ',';
                }
            } else {
                $ejecutarJson = true;
                if (method_exists(get_class($value), 'getJSON')) {
                    $ejecutarJson = false;
                }
                if (!$ejecutarJson) {
                    $resp .= '"' . $key . '":' . $value->getJSON() . ',';
                } else {
                    $resp .= '"' . $key . '":' . json_encode($value) . ',';
                }
            }
        }
        $resp = substr($resp, 0, -1) . "}";
        return $resp;
    }
	
	
	public static function getProductList($articulo){
		$retorno = array();
        if (is_a($articulo, 'Articulo')) {
            $sentencia_sql = 'SELECT ' . static::getCampos() . ' 
								FROM ' . static::getNombreTabla() . '
								WHERE ' . static::getWhereTabla($articulo->codigo, false);
            //echo("$sentencia_sql\n");
            $bd = new BaseDatos();
            if ($bd->isConectado()) {
                $bd->setConsultaSQL($sentencia_sql);
                while ($fila = $bd->getFila()) {
                    $retorno[]= new Url_fotos_articulo(array('filaUrl_fotos_articulo' => $fila));
                }
            }
        }

		return($retorno);
	}
	
	
	

}
?>