<?php
//---------------------------------------------------------------------------------------------------------
// 23/Septiembre/2020 ==> Módulo que muestra las imágenes de toto
//---------------------------------------------------------------------------------------------------------
//Los módulos heredan los atributos de la clase Module:
/*	$templateFile = '';
	$loadedModules = array();
	$modulesList = array();
	$options = NULL;
	$data_update = '';
*/

class Totto_imagenes extends Module{
	//Definimos la lista de acciones que ejecutará este módulo
	protected static $actionList = array('');

	//Función que instala el módulo
	public function install(){
		//Es necesario crear una tabla con este widget:
		$sqlCreate = 'CREATE TABLE `url_fotos_articulo` (
			`codigo` bigint(20) NOT NULL,
			`articulo` int(11) NOT NULL,
			`url` varchar(512) NOT NULL
		  ) ENGINE=MyISAM DEFAULT CHARSET=latin1;';
		$sqlIndex = 'ALTER TABLE `url_fotos_articulo`
		ADD PRIMARY KEY (`codigo`),
		ADD KEY `articulo` (`articulo`);';
		//TODO: hay que ejecutar la consulta mysql:
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			//trazas:
			$bd->setConsultaSQL($sqlCreate);
			$bd->setConsultaSQL($sqlIndex);
		}
	}
	
	//Función que desinstala el módulo
	public function uninstall(){
		$sqlCreate = 'DROP TABLE IF EXISTS `url_fotos_articulo` ;';
		//TODO: hay que ejecutar la consulta mysql:
		$bd = new BaseDatos();
		if ($bd->isConectado()){
			//trazas:
			$bd->setConsultaSQL($sqlCreate);
		}
		
	}
	
	
	//constructor:
	public function __construct() {
		//Cargamos la la clase de url de fotos de artículos
		require_once(_WS_MODULES_DIR_ . strtolower(get_class($this)) . '/lib/url_fotos_articulo.php');
	
	}
	
	//Aquí vienen ahora las funciones que se encargan de añadir funciones a los eventos de webStore
	
	//Esta función es la encargada de ejecutar del módulo lo que sea necesario:
	public function execute(){
		$opciones_recibidas = new ObOptions($this->getModuleOptions());	//Recogemos las opciones que nos puedan haber mandado
		//$variable = $opciones_recibidas->getDefaultValue('nombre_opcion', valor_x_defecto);
		//Lo que va a hacer este módulo es mostrar la imagen de Tootto, si no existe en la tabla ejecutará el widget de toda la vida:
		$articulo = $opciones_recibidas->getDefaultValue('articulo', NULL);
		$soloPortada = $opciones_recibidas->getDefaultValue('soloPortada', false);
		$opcionesWidgetOriginal = $opciones_recibidas->getDefaultValue('opcionesWidgetOriginal', array());
		$funcionWidget = $opciones_recibidas->getDefaultValue('funcionWidget', NULL);
		
		//Defino las opciones que le voy a pasar a la vista
		$options = new stdClass();
		$options->opcionesWidgetOriginal = $opcionesWidgetOriginal;
		$options->funcionWidget = $funcionWidget;
		$listaFotos = array();
		$fotoArticulo = NULL;
		if (is_a($articulo, 'Articulo')){
			if ($soloPortada){
				$options->fotoArticulo = new Url_fotos_articulo(array('articulo' => $articulo));
				$this->setTemplateFile('totto_una_imagen.php');
			}else{
				//Vamos a cargar las fotos de totto:
				$lista_fotos = Url_fotos_articulo::getProductList($articulo);
				$array_lista_fotos = array();
				foreach($lista_fotos as $clave => $foto){
					$std = new stdClass();
					$std->nombre_fichero = $foto->url;
					$array_lista_fotos[] = $std;
				}
				$options->listaUrls = $array_lista_fotos;
				$this->setTemplateFile('totto_imagenes.php');
            }
		}

		//Lo último es asignar las opciones a la vista
		$this->setViewOptions($options);
	}


}