<?php
//---------------------------------------------------------------------------------------------------------
// 27/Noviembre/2015
// Versión 1.0 Fichero para mostrar la descarga del fichero del albaran
//---------------------------------------------------------------------------------------------------------

ini_set('memory_limit', '256M');
set_time_limit(600);
if ($numero_fichero != NULL) {
     $factura = new Factura($numero_fichero, true, false, false, $datos_usuario);
	//Vamos a ver si hay que cargar líneas o no:
	if ( (!$datos_usuario->factura_sin_detalle) || ($datos_usuario->factura_sin_detalle && $factura->n_albaranes == 1)) {
		$factura->cargar_albaranes();
	}
    ob_start(); // Abrimos un flujo par capturar el contenido y poder pasarlo a PDF
    ?>
    <style type="text/Css">
        <!--

        table#encabezado {
            width: 100%;
        }

        #datos, #datos_cliente{
            width:340px;
        }

        #datos p {
            padding-right: 40px;
            text-align: right;
            margin: 0px;
            font-size: 14px;
            font-weight: bold;
        }

        #datos p strong{
            font-size:18px;
        }

        #cuadro{
            border: 1px solid black;
            width: 390px;
            height: 200px;
        }


        #cuadro p {
            padding-left: 15px;
            margin-bottom: 0px;
            margin-top: 10px;
        }

        #cuadro p strong{
            font-weight: bold;
            margin-top: 9px;
            font-size: 18px;
            margin-bottom: 16px;
        }

        -->
    </style>
    <page backtop="84mm" backbottom="30mm" backleft="0mm" backright="0mm" footer="page">
        <page_header>
            <table id="encabezado">
                <tr class="fila">
                    <td id="datos_Shop::" >
                        <table width="340">
                            <tr>
                                <td>
                                    <?php new Widget($_WH->GW("banner"), "banner_factura", "cabecera_factura"); ?>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p height="20" style="font-size:16px;"><?= traducir(Shop::$empresa->nombre_legal); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p height="20" style="font-size:12px;"><?= traducir(Shop::$empresa->direccion); ?>  <?= traducir(Shop::$empresa->provincia); ?>  <?= Shop::$empresa->cod_postal; ?></p>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p height="20" style="font-size:16px;">Telf. <strong>957 325 790</strong>  Fax. <strong>957 083 662</strong></p>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td id="datos_cliente">
                        <div id="cuadro">
                            <p><strong><?= traducir($datos_usuario->nombre_legal); ?></strong></p>
                            <p><?= traducir($datos_usuario->nombre_comercial); ?></p>
                            <p><?= traducir($datos_usuario->direccion); ?></p>
                            <p><?= $datos_usuario->cod_postal . " " . traducir($datos_usuario->localidad); ?></p>
                            <p><?= traducir($datos_usuario->provincia); ?></p>
                            <p>C.I.F.:<?= $datos_usuario->cif; ?></p>
                            <p><?= traducir("Código"); ?>&nbsp;&nbsp;&nbsp;<?= $datos_usuario->codigo; ?></p>
                        </div>
                    </td>
                </tr>
            </table>

            <table id="datos_cab" style="margin-left:40px; margin-top:20px;">
                <tr>
                    <td>
                        <table id="num_doc" style="margin-left:5px;">
                            <tr>
                                <td>
                                    <div style="background-color:#FFF9D4; border:1px solid black; text-align:center; width:160px; margin:0px; padding:5px 0px 5px 0px;"><?= traducir("Albarán nº"); ?></div>
                                    <div style="border:1px solid black; text-align:center; padding:5px 0px 5px 0px;"><?= $factura->num_doc; ?></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table id="fecha_albaran" style="margin-left:10px;">
                            <tr>
                                <td>
                                    <div style="background-color:#FFF9D4; border:1px solid black; text-align:center; width:140px; margin:0px; padding:5px 0px 5px 0px;"><?= traducir("Fecha"); ?></div>
                                    <div style="border:1px solid black; text-align:center; padding:5px 0px 5px 0px;"><?= $factura->fecha_date_format->format("d/m/Y"); ?></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table id="tipo_doc" style="margin-left:10px;">
                            <tr>
                                <td>
                                    <div style="background-color:#FFF9D4; border:1px solid black; text-align:center; width:210px; margin:0px; padding:5px 0px 5px 0px;"><?= traducir("Documento"); ?></div>
                                    <div style="border:1px solid black; text-align:center; padding:5px 0px 5px 0px;"><?= $factura->tipo_doc_nombre; ?></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table id="tipo_doc" style="margin-left:10px;">
                            <tr>
                                <td>
                                    <div style="background-color:#FFF9D4; border:1px solid black; text-align:center; width:80px; margin:0px; padding:5px 0px 5px 0px;"><?= traducir("Pág"); ?></div>
                                    <div style="border:1px solid black; text-align:right; padding:5px 0px 5px 0px; width:80px;">[[page_cu]] de [[page_nb]]</div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <table class="lineas" style="background-color:#DCDCDC; padding:3px; border:1px solid black;">
                <tr class="cab_lineas">
                    <td style="vertical-align:top;"><div style="width:105px; text-align:right;"><?= traducir("Artículo"); ?></div></td>
                    <td style="vertical-align:top;"><div style="width:275px; margin-left:5px;"><?= traducir("Descripción"); ?></div></td>
                    <td style="vertical-align:top;"><div style="width:30px; text-align:right;"><?= traducir("Cant"); ?></div></td>
                    <td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?= traducir("PVP"); ?></div></td>
                    <td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?= traducir("IVA"); ?></div></td>
                    <td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?= traducir("siniva"); ?></div></td>
                    <td style="vertical-align:top;"><div style="width:30px; text-align:right;"><?= traducir("Dto."); ?></div></td>
                    <td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?= traducir("P.Unid."); ?></div></td>
                    <td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?= traducir("Importe"); ?></div></td>
                </tr>
            </table>
        </page_header>
        <page_footer>
            <table style="border:1px solid black; background-color:#DCDCDC; padding: 5px 15px;">
                <?php
                for ($i = 1; $i <= 4; $i++) {
                    $iva = "iva$i";
                    $base = "base$i";
                    $imp_iva = "imp_iva$i";
                    $recargo = "recargo$i";
                    $imp_recargo = "imp_recargo$i";
                    $bruto = "bruto$i";
                    if ($factura->$imp_iva != 0) {
                        ?>
                        <tr>
                            <td><div style="width:75px; text-align:right;"><?= traducir("Base al") . " " . str_pad($factura->$iva, 2, "0", STR_PAD_LEFT) . "%"; ?></div></td>
                            <td><div style="width:70px; text-align:right;"><?= number_format($factura->$base, 2) . "&euro;"; ?></div></td>
                            <td><div style="width:70px; text-align:right;"><?= traducir("Imp. iva:"); ?></div></td>
                            <td><div style="width:70px; text-align:right;"><?= number_format($factura->$imp_iva, 2) . "&euro;"; ?></div></td>
                            <?php
                            if ($factura->$imp_recargo != 0) {
                                ?>
                                <td><div style="width:220px;">&nbsp;</div></td>
                                <td><div style="width:65px; ">&nbsp;</div></td>
                                <td><div style="width:50px; ">&nbsp;</div></td>
                                <?php
                            } else {
                                ?>
                                <td><div style="width:220px; text-align:right;"><?= traducir("Recargo:") . " " . str_pad(number_format($factura->$recargo, 2), 2, "0", STR_PAD_LEFT) . "%"; ?></div></td>
                                <td><div style="width:65px; text-align:right;"><?= traducir("Imp. rec.:"); ?></div></td>
                                <td><div style="width:50px; text-align:right;"><?= number_format($factura->$imp_recargo, 2) . "&euro;"; ?></div></td>
                                <?php
                            }
                            ?>
                        </tr>
                        <?php
                    } else {
                        ?>
                        <tr>
                            <td><div style="width:75px; text-align:right;">&nbsp;</div></td>
                            <td><div style="width:70px; text-align:right;">&nbsp;</div></td>
                            <td><div style="width:70px; text-align:right;">&nbsp;</div></td>
                            <td><div style="width:70px; text-align:right;">&nbsp;</div></td>
                            <td><div style="width:220px;">&nbsp;</div></td>
                            <td><div style="width:65px; ">&nbsp;</div></td>
                            <td><div style="width:50px; ">&nbsp;</div></td>
                        </tr>
                        <?php
                    }
                }
                ?>
                <tr>
                    <td colspan="7"><div style="width:710px; text-align:right;font-size:20px;"><?= traducir("Total:") . " " . number_format($factura->total, 2) . "&euro;"; ?></div></td>
                </tr>
            </table>
        </page_footer>
        <table class="lineas" style="padding:5px;" cellpadding="0" cellspacing="0">
            <?php foreach ($factura->albaranes as $clave => $albaran) {
                ?>
            <tr style="font-weight: bold;">
                    <td style="vertical-align:top;"><div style="width:107px; height:26px; text-align:right;">&nbsp;</div></td>
                    <td style="vertical-align:top;"><div style="width:277px; height:26px; margin-left:5px;vertical-align: middle;"><?= traducir('Fecha').":&nbsp;".$albaran->fecha."&nbsp;&nbsp;&nbsp;".traducir("Numero").":&nbsp;".$albaran->num_doc; ?></div></td>
                    <td style="vertical-align:top;"><div style="width:32px; height:26px; text-align:right;">&nbsp;</div></td>
                    <td style="vertical-align:top;"><div style="width:52px; height:26px; text-align:right;">&nbsp;</div></td>
                    <td style="vertical-align:top;"><div style="width:52px; height:26px; text-align:right;">&nbsp;</div></td>
                    <td style="vertical-align:top;"><div style="width:52px; height:26px; text-align:right;">&nbsp;</div></td>
                    <td style="vertical-align:top;"><div style="width:52px; height:26px; text-align:right; vertical-align: middle;"><?= traducir("Importe"); ?></div></td>
                    <td style="vertical-align:top;"><div style="width:52px; height:26px; text-align:right; vertical-align: middle;"><?= number_format($albaran->total_albaran, 2) . "&euro;";?></div></td>
                    <td style="vertical-align:top;"><div style="width:52px; height:26px; text-align:right;">&nbsp;</div></td>
                </tr>
                <?php
                $contador = 0;
                $limite = 200;
				if ( (!$datos_usuario->factura_sin_detalle) || ($datos_usuario->factura_sin_detalle && $factura->n_albaranes == 1)) {
					foreach ($albaran->lineas_albaran as $key => $linea) {
						if ($contador < $limite) {
                        ?>
                       <tr>
                            <td style="vertical-align:top;"><div style="width:107px; height:18px; text-align:right;"><?= ($linea->ean != "") ? $linea->ean : $linea->articulo; ?></div></td>
                            <td style="vertical-align:top; margin-top:5px;"><div style="width:277px; margin-left:5px; height:15px; font-size:12px; overflow:hidden;"><?= $linea->descripcion; ?></div></td>
                            <td style="vertical-align:top;"><div style="width:32px; height:18px; text-align:right;"><?= $linea->cantidad; ?></div></td>
                            <td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?= number_format($linea->precio, 2); ?></div></td>
                            <td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?= $linea->iva; ?></div></td>
                            <td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?= number_format($linea->precio / (1 + ($linea->iva / 100)), 2); ?></div></td>
                            <td style="vertical-align:top;"><div style="width:32px; height:18px; text-align:right;"><?= $linea->descuento; ?></div></td>
                            <td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?= number_format($linea->precio, 2); ?></div></td>
                            <td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?= number_format($linea->importe, 2); ?></div></td>
                        </tr>
                        <?php
						}
						$contador ++;
					}
				}
            }
            ?>
        </table>
    </page>
    <?php
    $content = ob_get_clean();
    //Y ahora inicializamos el path

    ini_set('include_path', "../.." . PATH_SEPARATOR . get_include_path());
    require_once('comunes/pdf/html2pdf.class.php');
    try {
        $html2pdf = new HTML2PDF('P', 'A4', 'es');
       // $html2pdf->setModeDebug();
        $html2pdf->setDefaultFont('times');
        $html2pdf->setTestTdInOnePage(true);
        $html2pdf->writeHTML($content, isset($_GET['vuehtml']));
        $html2pdf->Output('factura' . $factura->num_doc . '.pdf', 'I');
    } catch (HTML2PDF_exception $e) {
        echo $e;
        exit;
    }
}
?>