<?php
//---------------------------------------------------------------------------------------------------------
// 10/Octubre/2014
// Versión 1.0 Versión estándar del código html de una mini-ficha de artículo
//---------------------------------------------------------------------------------------------------------
// Versión 1.1 No se va a utilizar "articulo_a_mostrar" en su lugar usaremos una variable local llamada "articulo_a_mostrar"
//---------------------------------------------------------------------------------------------------------
// Versión 1.2 A partir de ahora se cargan los tamaños de las portadas de la tabla "tam_portadas"
// Y la imagen se muestra con "capa_imagen
//---------------------------------------------------------------------------------------------------------
/* Preparacion de los enlaces para las redes sociales de forma que no necesitemos los plugin oficiales */
$url = "https://" . $_SERVER['HTTP_HOST'] . ":" . $_SERVER['SERVER_PORT'] . $_SERVER['REQUEST_URI'];
$url_facebook = "http://facebook.com/sharer.php?u=" . urlencode($url);
$urltwitter = "http://twitter.com/home?status=" . urlencode($url);
$urlgoogle = "https://plus.google.com/share?url=" . urlencode($url) . '&media=http://www.sinlib.es/portadasSinlib/muestraFoto.php?ean=' . $articulo_a_mostrar->ean . '&ancho=300&alto=300&calidad=100&fichero_no_foto=arminet.jpg';
$urlwasap = "whatsapp://send?text=" . urlencode($url) . '&media=http://www.sinlib.es/portadasSinlib/muestraFoto.php?ean=' . $articulo_a_mostrar->ean . '&ancho=300&alto=300&calidad=100&fichero_no_foto=arminet.jpg';
$urlpinterest = 'http://pinterest.com/pin/create/button/?url=' . urlencode($url) . '&media=http://www.sinlib.es/portadasSinlib/muestraFoto.php?ean=' . $articulo_a_mostrar->ean . '&ancho=300&alto=300&calidad=100&fichero_no_foto=arminet.jpg';
$product = $articulo_a_mostrar;
?>

<?php
escupirMiga('prd', true, ">"); //El segundo valor indica que quiero una miga compuesta por el servidor
?>
<div class="bloque_ficha">
    <div class="primary_block">

        <div class="pb-left-column col-xs-12 col-sm-6 col-md-5">
            <div id="image-block" class="clearfix">
                <?php
                //Debemos de poner el código de cliente de Hedra
                $opciones = new OpcionesWidget(array("ean" => $product->ean, "cliente" => Shop::$configuracion->cliente_arminet, "ruta_base" => "https://sinlib.es/"));
                new Widget($_WH->GW("multifoto", "mostrarPortadaMultiFotoLupita"), $opciones);
                ?>	
            </div>



        </div>
        <div class="pb-center-column col-xs-12 col-sm-6 col-md-7">
            <h2 itemprop="name"><?= $product->nombre; ?></h2>
            <div class="box-precio col-xs-12 col-lg-4">
                <div class="semaforo">
                    <?php
                    if ($articulo_a_mostrar->stock <= 0) {
                        ?>
                        <i class="mdi mdi-checkbox-blank-circle red" title="<?= traducir('No hay existencias'); ?>"></i>
                        <i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('No hay existencias'); ?>"></i>
                        <i class="mdi mdi-checkbox-blank-circle-outline" title="<?= traducir('No hay existencias'); ?>"></i>
                        <?php
                    } else if ($articulo_a_mostrar->stock == 1) {
                        ?>
                        <i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('Quedan pocas existencias'); ?>"></i>
                        <i class="mdi mdi-checkbox-blank-circle yellow" title="<?= traducir('Quedan pocas existencias'); ?>"></i>
                        <i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('Quedan pocas existencias'); ?>"></i>
                        <?php
                    } else {
                        ?>
                        <i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('Hay bastantes existencias'); ?>"></i>
                        <i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('Hay bastantes existencias'); ?>"></i>
                        <i class="mdi mdi-checkbox-blank-circle green" title="<?= traducir('Hay bastantes existencias'); ?>"></i>
                        <?php
                    }
                    ?>
                </div>
                <div id="priceAndBuy" class="no-print">
                    <?php
                    if ($product->pvp_final != $product->pvp) {
                        ?>
                        <p id="old_price" class="">
                            <span id="old_price_display">
                                <span class="price"><?= number_format($product->pvp, Shop::$configuracion->decimales, ",", "."); ?> &euro;</span>
                            </span>
                        </p>
                        <p class="our_price_display" >
                            <span id="our_price_display" class="price"><?= number_format($product->pvp_final, Shop::$configuracion->decimales, ",", "."); ?> &euro;  </span>
                        </p>
                        <?php
                    } else {
                        ?>
                        <p class="our_price_display" >
                            <span id="our_price_display" class="price"><?= number_format($product->pvp_final, Shop::$configuracion->decimales, ",", "."); ?> &euro;</span>
                        </p>
                        <?php
                    }
                    ?>
                    <div class="box-cart-bottom">
                        <?php
                        //Boton comprar
                        $conf = new OpcionesWidget(array(
                            'articulo' => $product,
                            'fichero_boton' => 'botonComprarAmpliadaRelacionadosFooter',
                            'cantidad_dinamica' => true,
                            'addBtnCantidad' => true
                        ));
                        new Widget($_WH->GW("articulo", "btnComprar"), $conf);
                        ?>
                    </div>
                </div>
            </div>
            <div class="box-info-product col-xs-12 col-lg-8">
                <div class="ean">
                    <strong><?= $product->ean ?></strong>
                </div>

                <?php
                if($product->subtitulo != ''){
                    ?>
                <p id="product_sub"> <?= $product->subtitulo ?> </p>
                <?php
                }
                ?>
                 <?php
                if ($product->autor != '') {
                    ?>
                    <div class="odd">
                        <span class="titulo"><?= traducir('Autor') ?></span>
                        <span><a href="<?= corregir_url(Shop::$configuracion->url . "autor/" . $product->autor); ?>" title="<?= $product->autor ?>"><?= $product->autor ?></a></span>
                    </div>
                    <?php
                }
                if ($product->editorial != '') {
                    ?>
                    <div class="even">
                        <span class="titulo"><?= ($product->tipo == "L") ? traducir('Editorial') : traducir('Fabricante'); ?></span>
                        <span><a href="<?= corregir_url(Shop::$configuracion->url . "editorial/" . $product->editorial); ?>" title="<?= $product->editorial ?>"><?= $product->editorial ?></a></span>
                    </div>
                    <?php
                }
                ?>
               <?php
                    if ($product->ilustrador != '') {
                        ?>
                        <div class="even">
                            <span class="titulo"><?= traducir('Ilustrador'); ?>: </span>
                            <span><?= $product->ilustrador ?></span> 
                        </div>
                        <?php
                    }
                    if ($product->coleccion > 0) {
                        ?>
                        <div class="even">
                            <span class="titulo"><?= traducir('Colección'); ?>: </span>
                            <span><a href="<?= corregir_url(Shop::$configuracion->url . "coleccion/" . $product->nombreColeccion); ?>" title="<?= $product->nombreColeccion ?>"><?= $product->nombreColeccion ?></a></span>
                        </div>
                        <?php
                    }
                    if ($product->numeroColeccion > 0 ){
                        ?>
                        <div class="even">
                            <span class="titulo"><?= traducir('Número en la colección'); ?>: </span>
                            <span><?= $product->numeroColeccion ?></span>
                        </div>
                        <?php
                    }
                    if ($product->encuadernacion != '') {
                        ?>
                        <div class="even">
                            <span class="titulo"><?= traducir('Encuadernación'); ?>: </span>
                            <span><?= $product->encuadernacion ?></span>
                        </div> 
                        <?php
                    }


                    if ($product->num_paginas > 0) {
                        ?>
                        <div class="even">
                            <span class="titulo"><?= traducir('Páginas'); ?>: </span>
                            <span><?= $product->num_paginas ?></span>
                        </div> 
                        <?php
                    }
                    if ($product->alto > 0 && $product->ancho) {
                        ?>
                        <div class="even">
                            <span class="titulo"><?= traducir('Tamaño'); ?>: </span>
                            <span><?= $product->ancho ?>cm X <?= $product->alto ?>cm</span>
                        </div> 
                        <?php
                    }
                    if ($product->peso > 0) {
                        ?>
                        <div class="even">
                            <span class="titulo"><?= traducir('Peso'); ?>: </span>
                            <span><?= $product->peso ?> gr</span>
                        </div>
                        <?php
                    }
                    ?>

                <?php                
                //compara la descripcion seo con la descripcion completa, si son distintas muestra la seo
                $descripcion_resumida = $product->descripcion_seo;
                $masinfo = false;
                if (strtoupper($product->descripcion_seo) == strtoupper($product->observaciones)) {
                    $descripcion_resumida = strip_tags($product->observaciones, '<strong><a>');
					$descripcion_resumida = substr($product->observaciones, 0, 250);
                    //si la descripcion ya resumida es distinta de la completa le añade puntos suspensivos
                    if (strnatcasecmp($descripcion_resumida, $product->observaciones) != 0) {
                        $descripcion_resumida .= '...';
                        $masinfo = true;
                    }
                }
                if ($descripcion_resumida != '') {
                    ?>
                    <p class="descripcion_corta">
                        <?= $descripcion_resumida; ?>

                        <?php
                        if ($masinfo) {
                            ?>
                            <strong><a id="seguir" href="javascript:$('html,body').animate({scrollTop: $('#ancla').offset().top-100},'slow');"><?= traducir('Seguir leyendo'); ?></a></strong>
                            <?php
                        }
                        ?>
                    </p>
                    <?php
                }
                ?>

               
                <p class="socialsharing_product no-print">
                    <a class="solcial facebook btn" href="<?= $url_facebook ?>" target="_blank">
                        <i class="mdi mdi-facebook"></i>  
                    </a>                        
                    <a class="solcial twitter btn" href="<?= $urltwitter ?>" target="_blank">
                        <i class="mdi mdi-twitter"></i>   
                    </a>
                    <a class="solcial pinterest btn " href="<?= $urlpinterest ?>" target="_blank">
                        <i class="mdi mdi-pinterest"></i> 
                    </a>
                    <a class="solcial wasap btn" href="<?= $urlwasap ?>" target="_blank">

                        <i class="mdi mdi-whatsapp"></i> 
                    </a>
                </p>

            </div>


        </div>
        <div id="views_block" class="clearfix col-xs-12 col-sm-6 col-md-7">
            <div id="thumbs_list">
                <?php
                $opciones_extraFoto = new OpcionesWidget(array("ean" => $product->ean, "cliente" => Shop::$configuracion->cliente_arminet, "ruta_base" => "https://sinlib.es/"));
                $opciones_extraFoto->addProperty("tam_portada", "foto_extra");
                new Widget($_WH->GW("multifoto", "mostrarExtraFotos"), $opciones_extraFoto);
                ?>
            </div>
        </div>
        <?php
        if ($product->observaciones != '' ||
                $product->ilustrador != '' ||
                $product->coleccion != '' ||
                $product->encuadernacion != '' ||
                $product->peso > 0 ||
                $product->num_paginas > 0 ||
                ($product->alto > 0 && $product->ancho)) {
            ?>
            <div  id="ancla" class="info_total">
                                <?php
                if ($product->observaciones != '') {
                    ?>
					<span class="title_info_total"><?= traducir('Información Extra'); ?></span>

                    <div class="box-description">
                        <?= $product->observaciones; ?>
                    </div>  
                    <?php
                } 
                ?>
            </div>
            <?php
        }
        ?>
    </div>
    <?php
    //Cargamos 3 productos relacionados con éste
    $relacionados = $articulo_a_mostrar->productos_relacionados();
    if ($relacionados > 0) {
        ?>
        <div id="productos_relacionados" class="col-lg-12">
            <h4 class="title_block"><?= traducir('Productos Relacionados'); ?>:</h4>
            <?php
            $widget_relacionados = new Widget($_WH->GW('articulo', 'lista_articulos'), 'mini_ficha', $articulo_a_mostrar->lista_articulos);
            ?>
        </div>
        <?php
    }
    ?>
</div>


<!--Datos para google shoping-->
<span itemprop="name" content="<?= $product->nombre; ?>"></span>
<span itemprop="offerURL" content="<?= $product->url; ?>"></span>
<span itemprop="image" content="<?= Shop::$configuracion->url; ?>portada/600/600/<?= $product->ean; ?>.jpg"></span>
<span itemprop="offerDetails" itemscope itemtype="http://data-vocabulary.org/Offer">
    <span itemprop="identifier" content="isbn:<?= $product->ean; ?>"></span>
    <span class="precio-producto">
        <span itemprop="price" content="<?= number_format($product->pvp, Shop::$configuracion->decimales, ",", "."); ?>"></span>
        <span itemprop="currency" content="EUR"></span>
    </span>
    <?php
    if ($product->stock > 0) {
        $disponibilidad = "in_stock";
    } else {
        $disponibilidad = "out_of_stock";
    }
    ?>
    <span itemprop="availability" content="<?= $disponibilidad; ?>"></span>
</span>
<!-- Datos para Facebook -->
<meta property="og:title" content="<?= $product->nombre; ?>">
<meta property="og:type" content="article">
<meta property="og:description" content="<?= $product->observaciones; ?>">
<meta property="og:url" content="<?= $product->url; ?>">
<meta property="og:image" content="<?= Shop::$configuracion->url; ?>portada/600/600/<?= $product->ean; ?>.jpg">
<meta property="og:site_name" content="<?= Shop::$configuracion->url; ?>">