<?php
//---------------------------------------------------------------------------------------------------------
// 10/Octubre/2014
// Versión 1.0 Versi�n est�ndar del c�digo html de una mini-ficha de artículo
//---------------------------------------------------------------------------------------------------------
// Versión 1.1 No se va a utilizar "articulo_a_mostrar" en su lugar usaremos una variable local llamada "articulo_a_mostrar"
//---------------------------------------------------------------------------------------------------------
// Versión 1.2 A partir de ahora se cargan los tamaños de las portadas de la tabla "tam_portadas"
//---------------------------------------------------------------------------------------------------------
//Si tenemos configurada la web para coger menos anchura, entonces tenemos que utilizar la siguiente sentencia:
//<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
//Usamos más anchura en la web, nos entran más portadas:
//En el Home hemos definido una variable para saber si estamos en el banner de novedades o no:
GLOBAL $estamosEnNovedades;
$tamCapa = "2";
if ($estamosEnNovedades) {
    $tamCapa = "3";
}
?>
<div class="escaparate col-xs-6 col-sm-6 col-md-4 <?= $estamosEnNovedades ? 'col-lg-2' : 'col-lg-3'; ?>">
    <div class="item-inner">
        <div class="left-block">
            <div class="product-image-container">
				<div class="front face">
					<a href="<?= $articulo_a_mostrar->url; ?>" title="<?= $articulo_a_mostrar->nombre; ?>" >
						<figure>
							<?php
							$opciones = new OpcionesWidget(array("ean" => $articulo_a_mostrar->ean, "cliente" => Shop::$configuracion->cliente_arminet, "ruta_base" => "https://sinlib.es/", "tam_portada" => "mini_ficha"));
							new Widget($_WH->GW("multifoto", "mostrarPortada"), $opciones);
							?>
						</figure>
					</a>
				</div>
                <div class="button-container face">
                    <div class="cart-button title_font">


                        <p class="descripcion" onclick="window.location.href = '<?= $articulo_a_mostrar->url; ?>';">
                            <?php
                                //02-04-2019(Marina) 
                                //le añade puntos suspensivos a la descripcion seo
                                $descripcion_resumida =$articulo_a_mostrar->descripcion_seo;
                                if(strlen($descripcion_resumida)>=210){
                                    $descripcion_resumida=substr($articulo_a_mostrar->descripcion_seo,0,210);
                                    $descripcion_resumida.='...';
                                }
                            ?>
                            <?= $descripcion_resumida; ?> 
                        </p>



                        <div class="odd">
                            <?php
                            if ($articulo_a_mostrar->autor != '') {
                                ?>

                                <span><?= traducir('Autor') ?></span>
                                <strong><a href="<?= corregir_url(Shop::$configuracion->url . "autor/" . $articulo_a_mostrar->autor); ?>" title="<?= $articulo_a_mostrar->autor ?>"><?= $articulo_a_mostrar->autor ?></a></strong>

                                <?php
                            }
                            ?>
                        </div>

                        <div class="even">
                            <?php
                            if ($articulo_a_mostrar->editorial != '') {
                                ?>

                                <span><?= ($articulo_a_mostrar->tipo == "L") ? traducir('Editorial') : traducir('Fabricante'); ?></span>
                                <strong><a href="<?= corregir_url(Shop::$configuracion->url . "editorial/" . $articulo_a_mostrar->editorial); ?>" title="<?= $articulo_a_mostrar->editorial ?>"><?= $articulo_a_mostrar->editorial ?></a></strong>
                                <?php
                            }
                            ?>                          
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="right-block">
            <h5 itemprop="name">
                <a class="product-name" href="<?= $articulo_a_mostrar->url; ?>" title="<?= $articulo_a_mostrar->nombre ?>" >
                    <?= $articulo_a_mostrar->nombre ?>
                </a>
            </h5>
            <div class="price-rating">
            <?php
              if ($articulo_a_mostrar->pvp_final != $articulo_a_mostrar->pvp) {
                  ?>
                  <span class="old-price product-price"><?= number_format($articulo_a_mostrar->pvp, 2, ',','.'); ?>&euro;</span>
                  <span class="precio_final"><?= number_format($articulo_a_mostrar->pvp_final, 2, ',', '.'); ?>&euro;</span>
                  <?php
              } else {
                  ?> 
                  <span class="precio_actual"><?= number_format($articulo_a_mostrar->pvp_final, 2, ',', '.'); ?>&euro;</span>
                  <?php
              }
              ?>  
            </div>
            <div class="divcomprar">
                <?php
                $conf = new OpcionesWidget(array("articulo" => $articulo_a_mostrar, 'fichero_boton' => 'botonComprarFlip'));
                new Widget($_WH->GW("articulo", "btnComprar"), $conf);
                ?>
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
</div>
