<?php
//---------------------------------------------------------------------------------------------------------
// 27/Noviembre/2015
// Versión 1.0 Fichero para mostrar la descarga del fichero del albaran
//---------------------------------------------------------------------------------------------------------
define("MAX_LINES", 31);
define("LINE_HEIGHT", 18);
global $albaran;

if ($numero_fichero != NULL) {
    $albaran = new Albaran($numero_fichero, true, true, false);

	ini_set('memory_limit', '64M');
	set_time_limit ( 120 );
?>
<style type="text/Css">


table#encabezado {
	width: 100%;
}

#datos_Shop, #datos_cliente{
	width:340px;	
}

#datos_Shop p {
	padding-right: 40px;
	text-align: right;
	margin: 0px;
	font-size: 14px;
	font-weight: bold;
}

#datos_Shop p strong{
	font-size:18px;
}

#cuadro{
	border: 1px solid black;
	width: 390px;
	height: 200px;
}


#cuadro p {
	padding-left: 15px;
	margin-bottom: 0px;
	margin-top: 10px;
}

#cuadro p strong{
	font-weight: bold;
	margin-top: 9px;
	font-size: 18px;
	margin-bottom: 16px;
}




</style>
<?php
$cab_albaran = getCabAlbaran();
$pie_albaran = getPieAlbaran();
echo($cab_albaran);
?>

<table class="lineas" style="padding:5px;" cellpadding="0" cellspacing="0">
<?php
		$contador = 0;
		foreach ($albaran->lineas_albaran as $key => $linea) {
			$articulo = $linea->objeto_articulo;
?>
	<tr>
		<td style="vertical-align:top;"><div style="width:107px; height:18px; text-align:right;"><?=($articulo->ean != "") ? $articulo->ean : $linea->articulo;?></div></td>
		<td style="vertical-align:top; margin-top:5px;"><div style="width:277px; margin-left:5px; height:15px; font-size:12px; overflow:hidden;"><?=$linea->descripcion;?></div></td>
		<td style="vertical-align:top;"><div style="width:32px; height:18px; text-align:right;"><?=$linea->cantidad;?></div></td>
		<td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?=number_format($linea->precio, 2);?></div></td>
		<td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?=$linea->iva;?></div></td>
		<td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?=number_format($linea->precio / (1 + ($linea->precio / 100)), 2);?></div></td>
		<td style="vertical-align:top;"><div style="width:32px; height:18px; text-align:right;"><?=$linea->descuento;?></div></td>
		<td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?=number_format($linea->precio, 2);?></div></td>
		<td style="vertical-align:top;"><div style="width:52px; height:18px; text-align:right;"><?=number_format($linea->importe, 2);?></div></td>
	</tr>
<?php
			if ($contador == MAX_LINES){
?>
</table>
<?php
				echo($pie_albaran);
				echo($cab_albaran);
?>
<table class="lineas" style="padding:5px;" cellpadding="0" cellspacing="0">
<?php				
				$contador = 0;
			}else{
				$contador ++;
			}
		}
	//Hay que reservar un espacio del tamaño de las líneas restantes * alto linea:
	$espacio_restante = (MAX_LINES - $contador) * LINE_HEIGHT;
?>
</table>
	<div style="height:<?=$espacio_restante;?>px"></div>

<?=$pie_albaran;?>


<?php

}


//Estas funciones devuelven las partes:
function getCabAlbaran (){
	include("comunes/globals.php");
	global $albaran;

	ob_start();
?>
<table id="encabezado" style="display:block;page-break-inside: avoid;">
	<tr class="fila">
		<td id="datos_Shop" >
			<table width="340">
				<tr>
					<td>
			<?php new Widget($_WH->GW("banner"), "banner_factura", "cabecera_factura");?>
					</td>
				</tr>
				<tr>
					<td>
				<p height="20" style="font-size:16px;"><?=traducir(Shop::$empresa->nombre_legal);?></p>
					</td>
				</tr>
				<tr>
					<td>
				<p height="20" style="font-size:12px;"><?=traducir(Shop::$empresa->direccion);?>  <?=traducir(Shop::$empresa->provincia);?>  <?=Shop::$empresa->cod_postal;?></p>
					</td>
				</tr>
				<tr>
					<td>
				<p height="20" style="font-size:16px;">Telf. <strong>957 325 790</strong>  Fax. <strong>957 083 662</strong></p>
					</td>
				</tr>
			</table>
		</td>
		<td id="datos_cliente">
			<div id="cuadro">
				<p><strong><?=traducir($datos_usuario->nombre_legal);?></strong></p>
				<p><?=traducir($datos_usuario->nombre_comercial);?></p>
				<p><?=traducir($datos_usuario->direccion);?></p>
				<p><?=$datos_usuario->cod_postal . " " . traducir($datos_usuario->localidad);?></p>
				<p><?=traducir($datos_usuario->provincia); ?></p>
				<p>C.I.F.:<?= $datos_usuario->cif; ?></p>
				<p><?=traducir("Código");?>&nbsp;&nbsp;&nbsp;<?=$datos_usuario->codigo;?></p>
			</div>
		</td>
	</tr>
</table>
<table id="datos_cab" style="margin-left:40px; margin-top:20px;">
	<tr>
		<td>
			<table id="num_doc" style="margin-left:10px;">
				<tr>
					<td>
						<div style="background-color:#FFF9D4; border:1px solid black; text-align:center; width:160px; margin:0px; padding:5px 0px 5px 0px;"><?=traducir("Albarán nº");?></div>
						<div style="border:1px solid black; text-align:center; padding:5px 0px 5px 0px;"><?=$albaran->num_doc;?></div>
					</td>
				</tr>
			</table>
		</td>
		<td>
			<table id="fecha_albaran" style="margin-left:10px;">
				<tr>
					<td>
						<div style="background-color:#FFF9D4; border:1px solid black; text-align:center; width:140px; margin:0px; padding:5px 0px 5px 0px;"><?=traducir("Fecha");?></div>
						<div style="border:1px solid black; text-align:center; padding:5px 0px 5px 0px;"><?=$albaran->fecha_date_format->format("d/m/Y");?></div>
					</td>
				</tr>
			</table>
		</td>
		<td>
			<table id="tipo_doc" style="margin-left:10px;">
				<tr>
					<td>
						<div style="background-color:#FFF9D4; border:1px solid black; text-align:center; width:180px; margin:0px; padding:5px 0px 5px 0px;"><?=traducir("Documento");?></div>
						<div style="border:1px solid black; text-align:center; padding:5px 0px 5px 0px;"><?=$albaran->nombre_tipo_doc;?></div>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>

<table class="lineas" style="background-color:#DCDCDC; padding:3px; border:1px solid black;">
	<tr class="cab_lineas">
		<td style="vertical-align:top;"><div style="width:105px; text-align:right;"><?=traducir("Artículo");?></div></td>
		<td style="vertical-align:top;"><div style="width:275px; margin-left:5px;"><?=traducir("Descripción");?></div></td>
		<td style="vertical-align:top;"><div style="width:30px; text-align:right;"><?=traducir("Cant");?></div></td>
		<td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?=traducir("PVP");?></div></td>
		<td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?=traducir("IVA");?></div></td>
		<td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?=traducir("siniva");?></div></td>
		<td style="vertical-align:top;"><div style="width:30px; text-align:right;"><?=traducir("Dto.");?></div></td>
		<td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?=traducir("P.Unid.");?></div></td>
		<td style="vertical-align:top;"><div style="width:50px; text-align:right;"><?=traducir("Importe");?></div></td>
	</tr>
</table>


<?php
	$content = ob_get_clean();
	return($content);
}

function getPieAlbaran (){
	include("comunes/globals.php");
	global $albaran;
	ob_start();
?>
<table style="border:1px solid black; background-color:#DCDCDC; padding: 5px 15px; /*page-break-after: always; */page-break-inside: avoid;">
		<tr>
			<td colspan="7"><div style="width:710px; text-align:right;"><?=traducir("Ejem.:") . " " . $albaran->cantidad;?></div></td>
		</tr>
<?php

		for ($i = 1; $i <= 4; $i++) {
			$iva = "iva$i";
			$base = "base$i";
			$imp_iva = "imp_iva$i";
			$recargo = "recargo$i";
			$imp_recargo = "imp_recargo$i";
			$bruto = "bruto$i";
			if ($albaran->$imp_iva != 0){
?>
			<tr>
				<td><div style="width:85px; text-align:right;"><?=traducir("Base al") . " " . str_pad($albaran->$iva, 2, "0", STR_PAD_LEFT) . "%";?></div></td>
				<td><div style="width:70px; text-align:right;"><?=number_format($albaran->$base, 2) . "&euro;";?></div></td>
				<td><div style="width:70px; text-align:right;"><?=traducir("Imp. iva:");?></div></td>
				<td><div style="width:70px; text-align:right;"><?=number_format($albaran->$imp_iva, 2) . "&euro;";?></div></td>
<?php
				if($albaran->$imp_recargo == 0){
?>
				<td><div style="width:220px;">&nbsp;</div></td>
				<td><div style="width:65px; ">&nbsp;</div></td>
				<td><div style="width:50px; ">&nbsp;</div></td>
<?php
				}else{
?>
				<td><div style="width:220px; text-align:right;"><?=traducir("Recargo:") . " " . str_pad(number_format($albaran->$recargo, 2), 2, "0", STR_PAD_LEFT) . "%";?></div></td>
				<td><div style="width:65px; text-align:right;"><?=traducir("Imp. rec.:");?></div></td>
				<td><div style="width:50px; text-align:right;"><?=number_format($albaran->$imp_recargo, 2) . "&euro;";?></div></td>
<?php
				}
?>
			</tr>
<?php
			}else{
?>
			<tr>
				<td colspan="7"><div style="width:710px; text-align:right;">&nbsp;</div></td>
			</tr>
<?php
			}
		}
?>
			<tr>
				<td colspan="7"><div style="width:710px; text-align:right;font-size:20px;"><?=traducir("Total:") . " " . number_format($albaran->total_albaran, 2) . "&euro;";?></div></td>
			</tr>
	</table>
<?php
	$content = ob_get_clean();
	return($content);
}
?>