<?php
	//---------------------------------------------------------------------------------------------------------
	// 03/Septiembre/2015
	// Versión 1.0 Menú de usuario sin login
	//---------------------------------------------------------------------------------------------------------

		//VARIABLES:
		$usuario = Usuario::logueado();
		//OJO, el hash lo voy a usar varias veces, por eso lo voy a meter en una variable. los hash no son nunca iguales
		$hash = Shop::$configuracion->sign($usuario->getHash());
?>

<fieldset>
    <div class="form_content clearfix formulario">
	    <div class="row">
			<div class="form-group col-xs-12 col-md-6">
				<span><i class="mdi mdi-account"></i></span>
				<label for="nombre_usuario"><?=traducir('Nombre');?></label>
			    <input data-block="no_bloqueado" required class="input_formulario form-control" type="text" autocomplete="name" id="nombre_usuario" name="nombre_comercial" value="<?=$usuario->nombre_comercial;?>">
			</div>
			<div class="form-group col-xs-12 col-md-6">
				<span><i class="mdi mdi-email"></i></span>
				<label for="email_usuario"><?=traducir('Email');?></label>
			    <input readonly class="input_formulario form-control" type="email" autocomplete="email" id="email_usuario" name="email" value="<?=$usuario->email;?>">
			</div>
		</div>
		<div class="row tres">
			<div class="form-group col-xs-12 col-md-4">
				<span><i class="mdi mdi-phone"></i></span>
				<label for="telefono_usuario"><?=traducir('Teléfono');?></label>
			    <input data-block="no_bloqueado" class="input_formulario form-control" type="tel" autocomplete="tel" id="telefono_usuario" name="telefono" value="<?=$usuario->telefono;?>">
			</div>
			<div class="form-group col-xs-12 col-md-4">
				<span><i class="mdi mdi-cake-variant"></i></span>
				<label for="fecha_nacimiento_usuario"><?=traducir('Fecha nacimiento');?></label>
			    <input data-block="no_bloqueado" class="input_formulario form-control" type="date" autocomplete="bday" id="fecha_nacimiento_usuario" name="fecha_nacimiento" value="<?=$usuario->fecha_nacimiento;?>">
			</div>
			<div class="form-group col-xs-12 col-md-4">
				<span><i class="mdi mdi-account-card-details"></i></span>
				<label for="dni_usuario"><?=traducir('DNI');?></label>
			    <input data-block="no_bloqueado" class="input_formulario form-control" type="text" autocomplete="dni" id="dni_usuario" name="cif" value="<?=$usuario->cif;?>">
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<div class="required  autorizacion">
					<p><?=traducir('¿Nos autorizas para ofrecerte productos, servicios y fidelizarte como cliente?');?></p>
					<input name="comunicados" type="radio" required="required" class="si" value="1" id="comuncados_si" <?=($usuario->comunicados) ? 'checked' : '';?>>
					<label class="texto_si" for="comuncados_si"><?=traducir('Sí');?></label>

					<input name="comunicados" type="radio" required="required" class="no" value="0" id="comuncados_no" <?=(!$usuario->comunicados) ? 'checked' : '';?>>
					<label class="texto_no" for="comuncados_no"><?=traducir('No');?></label>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 panel-info">
				<div class="alert alert-warning">
				  <strong></strong> 
				</div>
				<div class="alert alert-success">
				  <strong><?=traducir('Tus datos se han modificado correctamente.');?></strong> 
				</div>

				<div class="alert alert-info">
				  <strong><?=traducir('Modificando datos.');?></strong> 
				</div>

				<div class="alert alert-danger">
				  <strong><?=traducir('No se han podido modificar tus datos.');?></strong> 
				</div>
			</div>
		</div>
    </div>
		<div class="row">
			<div class="col-xs-12 actualizar">
				<p class="submit">
				    <button type="submit" id="submitUserData" name="submitUserData" class="boton">
					<span>
					    <span><?=traducir('Actualizar datos');?></span>
				    </button>
				</p>
			</div>
		</div>
	<input type="hidden" name="hash" value="<?=$hash;?>">
</fieldset>
<script>
	document.addEventListener('WSLE', function(event) {
		//Vamos a obtener todos los inputs del formulario:
		var form = $('[value=\'<?=$hash;?>\']').closest('form');
		form.on('submit', function(event){
			event.preventDefault();
			$('.alert-warning').hide();
			$('.alert-danger').hide();
			$('.alert-success').hide();
			$('.alert-info').show();
			var data = $(this).serializeArray();
			var finalData = [];
			$.each(data, function(i, field){
				//$("#results").append(field.name + ":" + field.value + " ");
				finalData[field.name] = field.value;
			});
			data = Object.assign({}, finalData);
			/*for (var i=0; i < data.length; i++){
				console.log(data[i]);
				var key = data[i].name;
				var value = data[i].value;
				finalData[name] = value;
			}*/
			console.log(data);
			WS_data_update(
				'Usuario',
				'setUserData',
				data,
				'',
				function(objeto){
					form.find('[data-block=\'no_bloqueado\']').removeAttr('readonly');
					var respuesta = JSON.parse(objeto.response);
					console.log(respuesta);
					if(respuesta.error == 0){
						$('.alert-warning').hide();
						$('.alert-danger').hide();
						$('.alert-info').hide();
						$('.alert-success').show();
					}else{
						$('.alert-warning').hide();
						$('.alert-success').hide();
						$('.alert-info').hide();
						$('.alert-danger').show();
					}
				}
			);
			//Ocultamos el contenido del formulario
			//form.hide();
			$(this).find('[data-block=\'no_bloqueado\']').attr('readonly','readonly');
		});
		//$('#SubmitLogin').closest('form')
	});
	
</script>