 //---------------------------------------------------------------------------------------------------------
 // 04/Noviembre/2014
 // Versión 1.0 script que manipula la cesta
 //---------------------------------------------------------------------------------------------------------
 // 07/Noviembre/2014
 // Versión 1.1 Cuando se mueve la portada a la cesta, no se modifica la cantidad, eso se hace a parte
 //---------------------------------------------------------------------------------------------------------
 // 03/Marzo/2015
 // Versión 1.2 Cambiamos el funciomaiento de la cesta para separar los procesos
 //---------------------------------------------------------------------------------------------------------
// 07/Agosto/2018
 // Versión 2.0 Simplificamos el script, los cálculos que los haga webStore
 //---------------------------------------------------------------------------------------------------------

function emtpyCart(dataUpdate){
	dataUpdate = ((dataUpdate === undefined)||(dataUpdate === null)) ? '^="cart"' : dataUpdate;
	var data = {};
	WS_data_update(
		'CabeceraCesta',
		'emtpyCart',
		data,
		dataUpdate,
		function(data){
			//Redimensionamos la cesta:
			resizeModalBasket($("[class^='lineas_cesta']"), true);
		}
	);
}
 
function discardRestoreProducto(dataUpdate){
	dataUpdate = ((dataUpdate === undefined)||(dataUpdate === null)) ? '="cart-restore"' : dataUpdate;
	var data = {};
	WS_data_update(
		'CabeceraCesta',
		'discardRestoreProduct',
		data,
		dataUpdate,
		function(data){
			//Redimensionamos la cesta:
			resizeModalBasket($("[class^='lineas_cesta']"), true);
		}
	);
}

function addToBasket(data, resizeBasket, dataUpdate){
	//Pedro 23/Abril/2019 ==> Redimensionamos la cesta con esta variable que es muy útil cuando modificamos las cantidades directamente en la cesta
	resizeBasket = ((resizeBasket === undefined)||(resizeBasket === null)) ? true : resizeBasket;
	dataUpdate = ((dataUpdate === undefined)||(dataUpdate === null)) ? '^="cart"' : dataUpdate;
	//-------------------------------------------------
	// ==> Si hemos recibido un botón, vamos a tratar de mover la imagen:
	//-------------------------------------------------
	if ( (data.button != null) && (data.codigo_articulo != null) ){
		objeto = data.button;
		//Ojo, aquí vamos a controlar que no estemos borrando un producto:
		var accion = (data.accion != null) ? data.accion : 'sumar';
		if ( (accion == 'absoluto') && (parseInt(data.cantidad) == 0)){
			//Ojo que estamos borrando:
			objeto.closest(".contenedor_linea_cesta").each(function () {
				$(this).hide('fast');
			});
		}else{
			animateImageToBasket(data.codigo_articulo, objeto);
		}
	}
	//-------------------------------------------------
	// ==> Es posible que haya que cargar la cantidad de un objeto:
	//-------------------------------------------------
	if (data.element != null){
		var elemento = data.element;
		var tipo = elemento.prop('tagName').toLowerCase();
		//Según el tipo de elemento, vamos a ver la cantidad:
		if (tipo == 'select'){
			data.cantidad = elemento.text();
		}else{
			data.cantidad = elemento.val();
		}
	}
	var redimensionar = resizeBasket;
	WS_data_update(
		'CabeceraCesta',
		'addProduct',
		data,
		dataUpdate,
		function(data){
			//Redimensionamos la cesta:
			if (redimensionar){
				resizeModalBasket($("[class^='linea_cesta']"), true);
			}
		}
	);

}

function resizeModalBasket(capa, showBasket) {
    showBasket = ((showBasket === undefined)||(showBasket === null)) ? true : showBasket;
    if (capa.length > 0) {
        capa.closest("[class *= webStore]").each(function () {
            var id = $(this).attr("id");
            if (id != "") {
				//Recalculamos el alto 
                componentList.resize(id);
                if (showBasket) {
					//Lo mostramos
                    componentList.show(id);
                }
            }
        });
    }
}

function animateImageToBasket(codigo_articulo, boton_origen) {
//Vamos a buscar la imagen en función del codigo_articulo y del botón
    var imagen = boton_origen.parents("#ficha_producto_" + codigo_articulo).find("figure img[class^=imagen_]");
    //Vamos a obtener la posición del primer contenedor de "mini-cesta" que haya
    var elemento = $("[class ^= cesta_desplegable]");
	if (elemento.length > 0){
		if (elemento.visible()) {
			//El elemento se ve, vamos a mover la portada
			moveImageToBasket(imagen, elemento);
		} else {
			//El elemento no se ve, hay que hacerlo aparecer primero
			var copia = elemento.clone();
			//Vamos a quitar de el detalle de la cesta:
			copia.find('[class ^= "webStore"]').remove();
			//Desactivamos los eventos de copia
			copia.find(".lanzador_widget").removeProp("onmouseenter");
			copia.css({
				'position': 'fixed',
				'right': '0px',
				'top': '-' + elemento.outerHeight() + 'px',
				'margin': '0px'
			});
			copia.animate({
				'top': '0px'
			}, 500, function () {
				moveImageToBasket(imagen, copia, copia);
			});
			$("body").append(copia);
		}
	}
}

function moveImageToBasket(imagen, basket, cloneObject) {
//Esta función mueve la portada a la cesta especificada
//var copia_articulo = $("#ficha_producto_" + codigo_articulo + " figure img");
    if ((basket.length > 0) && (imagen.length > 0)) {
//Hay que coger la posición del elemento
        var posicion_cesta = basket.offset();
        var posicion_elemento = imagen.offset();
        //Ventana desplegable
        var ventana = basket.find("[class *= webStore]");
        //Vamos a calcular la velocidad, para ello primero calculamos la distancia
        var ancho_elemento = parseInt(imagen.width());
        var alto_elemento = parseInt(imagen.height());
        //Creamos un artículo igual, lo colocamos en la posición del artículo
        var elemento_auxiliar = $('<img src="' + imagen.prop("src") + '" />');
		//console.log(elemento_auxiliar);
        elemento_auxiliar.css({
            'position': 'absolute',
            'left': posicion_elemento.left + 'px',
            'top': posicion_elemento.top + 'px',
            'width': ancho_elemento + 'px',
            'height': alto_elemento + 'px'
        });
        $("body").append(elemento_auxiliar);
        //Desplazamos la copia hasta la cesta
        elemento_auxiliar.animate({
            'left': posicion_cesta.left + basket.outerWidth() / 2,
            'top': posicion_cesta.top + +basket.outerHeight() / 2,
            'width': (ancho_elemento / 100),
            'height': (alto_elemento / 100),
            'opacity': '0.5',
            '-webkit-opacity': '0.5',
            '-moz-opacity': '0.5'
        }, 950, function () {
            $(this).remove();
            if (cloneObject == null) {
                //Si no se ha clonado la cesta desplegable es porque no ha sido necesario, vamos a desplegarla
                if (ventana.length > 0) {
                    $("#" + ventana.prop("id")).mouseleave();
                }
            } else {
                //Hay que desplazar hacia arriba al elemento clonado
                cloneObject.animate({
                    'top': '-' + cloneObject.outerHeight() + 'px',
                }, 500, function () {
                    $(this).remove();
                });
            }
        });
    }else{
		cloneObject.remove();
	}
}
