<?php
	//---------------------------------------------------------------------------------------------------------
	// 03/Marzo/2015
	// Versi�n 1.0 C�digo est�ndar de la l�nea de la cesta
	// 28/Marzo/2016
	// version 1.1 agrupamos los datos como mejor nos conviene para el dise�o de la web
	// version 2.0 Añadimos el control para que en la cesta se vean los lotes
	//---------------------------------------------------------------------------------------------------------
	//Parámetros:
	//	1 => objeto línea

	//al crear la línea vamos a tener un campo llamado $linea que contendrá la línea que estamos mostrando
	//Por comodidad, voy a coger el artículo de la línea:
$linea = Theme::getLastParam(1);
$articulo = $linea->objeto_articulo;
$permitido_modificar_linea = true;
$mostrar_linea_completa = true;
$trabaja_cantidades_pvp = false;

if ($linea->lote != NULL){
	$trabaja_cantidades_pvp = $linea->lote->trabaja_cantidades_pvp;
}

if ( (is_a($articulo, 'Articulo')) && (!$trabaja_cantidades_pvp) ){
?>
<div class="estrecha linea_cesta_estilos <?=($linea->codigo_lote > 0) ? 'linea_lote' : 'linea_no_lote';?>">
	<div class="cabecera_producto col-xs-12">
		<p class="product-name">
			<a href="<?=$articulo->url;?>" title="<?=$articulo->nombre;?>"><?=$articulo->nombre;?></a>
		</p>
		<?php if ($permitido_modificar_linea){ ?>
		<div class="eliminar col-xs-2">
			<?php
			$script_btn_comprar = '{' 
				. 'codigo_articulo:' . $linea->articulo . ','
				. 'accion:\'absoluto\','
				. 'cantidad:0,'
				. (($linea->codigo_oferta > 0) ? 'oferta:' . $linea->codigo_oferta . ',' : '')
				. (($linea->codigo_lote > 0) ? 'lote:' . $linea->codigo_lote . ',' : '')
				. (($linea->puntos_gastados > 0) ? 'puntos_gastados:' . $linea->puntos_gastados . ',' : '')
				.'}';
			?>
			<!-- aqui va el boton de eliminar un producto de la cesta -->
			<a href="javascript:void(0);" onclick="addToBasket(<?=$script_btn_comprar;?>, false, '*=\'bloque_restaurar\'|*=\'bloque_linea_articulo_<?=$linea->articulo;?>\'|*=\'bloque_total_cesta\'');"><i class="mdi mdi-close"></i></a>
	    </div> 
		<?php } ?>
	</div>
	<div class="imagen_producto col-xs-2 col-sm-2 col-md-4 col-lg-2">
 		<a href="<?= $articulo->url; ?>" title="<?= $articulo->nombre; ?>">
		<?php
		//Cargamos la foto del producto
		$opciones = new OpcionesWidget(array("ean" => $articulo->ean, "cliente" => Shop::$configuracion->cliente_arminet, "ruta_base" => "https://sinlib.es/", "tam_portada" => "linea_cesta"));
		            new Widget($_WH->GW("multifoto", "mostrarPortada"), $opciones);
		?>	
    	</a>
    </div>
	<div class="info_producto col-xs-10 col-sm-10 col-md-8 col-lg-10">

		<div class="detalles_producto col-xs-10">
			<p class="editorial">
				<a href="<?= corregir_url(Shop::$configuracion->url . "editorial/" . $articulo->editorial); ?>" title="<?= $articulo->editorial ?>"><?= $articulo->editorial ?></a>
			</p>
			<p class="cart_ref"><?=traducir("EAN:");?> <?=$articulo->ean;?></p>
		</div>



		<div class="semaforo col-xs-10">
		<?php
		if ($articulo->stock <= 0) {
		?>
			<i class="mdi mdi-checkbox-blank-circle red" title="<?= traducir('No hay existencias'); ?>"></i>
				<i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('No hay existencias'); ?>"></i>
				<i class="mdi mdi-checkbox-blank-circle-outline" title="<?= traducir('No hay existencias'); ?>"></i>
		<?php
		} else if ($articulo->stock == 1) {
		?>
				<i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('Quedan pocas existencias'); ?>"></i>
				<i class="mdi mdi-checkbox-blank-circle yellow" title="<?= traducir('Quedan pocas existencias'); ?>"></i>
				<i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('Quedan pocas existencias'); ?>"></i>
		<?php
		} else {
		?>
				<i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('Hay bastantes existencias'); ?>"></i>
				<i class="mdi mdi-checkbox-blank-circle-outline " title="<?= traducir('Hay bastantes existencias'); ?>"></i>
				<i class="mdi mdi-checkbox-blank-circle green" title="<?= traducir('Hay bastantes existencias'); ?>"></i>
		<?php
		}
			?>
		</div>

		<?php if ($permitido_modificar_linea){ ?>

			<div class="cantidad col-xs-12 col-sm-4 " data-title="Cantidad">
				<div class="menos">
					<?php
					$scriptSumar = '{'
						. 'codigo_articulo:' . $linea->articulo . ','
						. ' accion:\'restar\', '
						. 'cantidad:1, '
						. (($linea->codigo_oferta > 0) ? 'oferta:' . $linea->codigo_oferta . ',' : '')
						. (($linea->codigo_lote > 0) ? 'lote:' . $linea->codigo_lote . ',' : '')
						. (($linea->puntos_gastados > 0) ? 'puntos_gastados:' . $linea->puntos_gastados . ',' : '')
						. '}';
						//Vamos a calcular la cantidad de regalo que tiene el producto:
						$cantidad_regalo = 0;
						if ($linea->oferta != NULL){
							$cantidad_regalo = ($linea->cantidad / $linea->oferta->cantidad) * $linea->oferta->cantidad_regalo;
						}
						//Cuando llamemos al onclick hay que pasar un false para no desplegar la cesta
					?>
					<a rel="nofollow" class="cart_quantity_down boton button-minus" href="javascript:void(0);" onclick="addToBasket(<?=$scriptSumar;?>, false, '*=\'bloque_restaurar\'|*=\'bloque_linea_articulo_<?=$linea->articulo;?>\'|*=\'bloque_total_cesta\'|*=\'bloque_tipo_envio\'');"  title="<?=traducir("Sustraer");?>"> 
					<span><i class="mdi mdi-minus"></i></span> 
					</a>
				</div>
				<div class="cantidad_articulos">
					<input size="2" type="text" readonly autocomplete="off" id="quantity_wanted<?=$articulo->codigo;?>" class="cart_quantity_input form-control grey" value="<?=$linea->cantidad;?>" name="quantity_5_19_0_0"/>
				</div>
				<div class="mas">
					<?php
					$scriptSumar = '{'
						. 'codigo_articulo:' . $linea->articulo . ','
						. ' accion:\'sumar\', '
						. 'cantidad:1, '
						. (($linea->codigo_oferta > 0) ? 'oferta:' . $linea->codigo_oferta . ',' : '')
						. (($linea->codigo_lote > 0) ? 'lote:' . $linea->codigo_lote . ',' : '')
						. (($linea->puntos_gastados > 0) ? 'puntos_gastados:' . $linea->puntos_gastados . ',' : '')
						. '}';
						//Cuando llamemos al onclick hay que pasar un false para no desplegar la cesta
					?>
					<a rel="nofollow" class="cart_quantity_up boton button-plus" href="javascript:void(0);" onclick="addToBasket(<?=$scriptSumar;?>, false, '*=\'bloque_linea_articulo_<?=$linea->articulo;?>\'|*=\'bloque_total_cesta\'|*=\'bloque_tipo_envio\'');" title="<?=traducir("Añadir");?>">
					<span><i class="mdi mdi-plus"></i></span>
					</a>
				</div>
			</div>
			<div class="col-xs-12 col-sm-8 cart_total" data-title="Total"> 
				<?php
				if ($articulo->pvp_final != $articulo->pvp) {
					?>
					<span class="precio_anterior"><?=number_format($articulo->pvp, 2, ",", ".");?>&euro;</span>
					<?php
				}
				if($linea->cantidad>1){	
				?>
					<span class="precio"><?=number_format($articulo->pvp_final, 2, ",", ".");?>&euro;</span>
					<span class="por"><i class="mdi mdi-close"></i> </span>
					<span class="cantidad_añadidos"><?=$linea->cantidad?></span>
					<span class="por"><i class="mdi mdi-equal"></i> </span>
				<?php
				}
				?>
				<span class="price" id="total_product_price_5_19_0"><?=number_format( ($articulo->pvp_final * $linea->cantidad), 2, ",", ".");?>&euro;</span>
			</div>
		<?php } ?>
	<!-- cierre del div info_producto -->
	</div>
</div>
<?php
}else if ( ($linea->lote->trabaja_cantidades_pvp) && ($linea->linea_lote->optativa) ){
	//Cuando es una optativa en un lote, sí la mostramos:
?>
<div class="first_item last_item <?=($linea->codigo_lote > 0) ? 'linea_lote' : 'linea_no_lote';?>" title="<?=$articulo->nombre;?> - <?= $articulo->editorial ?>" data-id="cart_block_product_<?=$articulo->codigo;?>">
	<div class="cart-info">
        <div class="product-name">
            <a href="<?=$articulo->url;?>" title="<?=$articulo->nombre;?>" class="cart_block_product_name">
                <span class="optativa"><?=traducir('Optativa:');?></span>
                <span class="nombre"><?=$articulo->nombre;?></span>
            </a>
        </div>
	</div>
</div>
<?php	
}
?>