//---------------------------------------------------------------------------------------------------------
// 04/Enero/2016
// Versión 1.0 Clase que contiene un array con funciones a ejecutar.
//---------------------------------------------------------------------------------------------------------

function FunctionStack(){
	//El constructor únicamente crea el array de funciones:
	this.funcArray = new Array();
}

//Funciónes del componente:

/*Añadir elemento:
	-Elemento a añadir
	-Posición en la que añadir. Si no se pasa nada, toma el valor true
		-True => Al inicio
		-False => Al final
*/
FunctionStack.prototype.add = function (element, position){
	if (!this.isAFunction(element)){
		return(false);
	}
	if (typeof(position === 'undefined')){
		position = true;
	}
	
	if (position){
		this.prepend(element);
	}else{
		this.apend(element);
	}
}


FunctionStack.prototype.prepend = function (element){
	if (this.isAFunction(element)){
		this.funcArray.unshift(element);
	}
}

FunctionStack.prototype.apend = function (element){
	if (this.isAFunction(element)){
		this.funcArray.push(element);
	}
}

FunctionStack.prototype.isAFunction = function (element){
	var getType = {};
	return(element && getType.toString.call(element) === '[object Function]');
}

FunctionStack.prototype.exec = function(){
	var tam = this.funcArray.length;
	for (var i = 0; i < tam; i++){
		var tmpElement = this.funcArray.shift();
		if (this.isAFunction(tmpElement)){
			tmpElement();
		}
	}
	
}