<?php
/* /-------------------------------------------------------------------------------------------------/
 *  28/Enero/2019
 *  Version 1.0
 *  Creados todos los campos posibles
 * /-------------------------------------------------------------------------------------------------/
 */
 
 //Cuando utilice este formulario, vamos a tener unas variables que nos pasará webStore y nos indicarán si ha sido correcto y los datos del usuario:
 // La variable es: $fileParams->args, dónde args es un array con los argumentos, por tanto el diseñador debe saber qué argumentos ha pasado al construir la web
 // En esta plantilla estamos pasando como argumentos :
 // 0 ==> el fichero de personalización
 // 1 ==> el resultado del registro
 // 2 ==> Los datos el usuario en un array:

$resultado_registro = Theme::getLastParam(1);
$datos_usuario = Theme::getLastParam(2);
if ($datos_usuario == NULL){
	$datos_usuario = array(
		'email_usuario' => '',
		'nombre_usuario' => ''
	);	
}
$showForm = true;
if ($resultado_registro === 0){
?>
<div class="alert alert-danger"><p class="error"><?=traducir('Ha ocurrido un error interno al intentar realizar el registro, inténtelo de nuevo. Disculpe las molestias.');?></p></div>
<?php
}else if ($resultado_registro == -1){
?>
<div class="alert alert-danger"><p class="error"><?=traducir('El email introducido ya se encuentra registrado en el sistema. Si ya es usuario registrado intente recuperar su contraseña.');?></p></div>
<?php
}else if ($resultado_registro == -2){
?>
<div class="alert alert-danger"><p class="error"><?=traducir('Las contraseñas introducidas no coinciden.');?></p></div>
<?php
}else if ($resultado_registro == -3){
?>
<div class="alert alert-danger"><p class="error" ><?=traducir('La contraseña introducida no cumple con el patrón de seguridad obligatorio. Debe contener números, letras mayúsculas y minúsculas.');?></p></div>
<?php
}else if ($resultado_registro == -4){
?>
<div class="alert alert-danger"><p class="error"><?=traducir('No ha rellenado todos los datos obligatorios. Por favor rellene todos los campos marcados con *.');?></p></div>
<?php
}else if ($resultado_registro == -5){
	$showForm = false;
?>
<div class="alert alert-success"><p class="okis"><?=traducir('Registro realizado con éxito, en breve recibirá un email en su dirección de correo con las instrucciones necesarias para verificar su identidad.');?></p></div>
<?php
}else if ($resultado_registro != ''){
	$showForm = false;
?>
<div class="alert alert-success"><p><?=traducir('Bienvenida/o.');?></p></div>
<?php	
}

//Si el resultado es -5 es porque el cliente se ha registrado bien, pero no se ha hecho login pq tiene q confirmar el código:

if ($showForm){

	$url = Getter::replaceOverlap(Shop::$configuracion->url, $_SERVER["REQUEST_URI"]);

	?>
	<div class="row">
		<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 registro_redes">
			<h3 class="page-subheading"><?= traducir('Acceder con'); ?></h3>
			<h4><?=traducir('Cuenta de Google');?></h4>
            <div class="google">
                <?php
                //	<div class="g-signin2" data-width="38" data-height="40" data-longtitle="true" data-onsuccess="googleCartRegister"></div>
                ?>
                <div id="customBtn" class="customGPlusSignIn">
                    <a href="javascript:void(0);" ><img  class="icono_red" src="<?=Theme::findFile('google.svg', false, true);?>" border="0" alt="<?= traducir('Identificarme con mi cuenta de Google'); ?>"></a>
                </div>
                <script>
                    document.addEventListener('WSLE', function (event) {
                        gapi.load('auth2', function () {
                            // Retrieve the singleton for the GoogleAuth library and set up the client.
                            auth2 = gapi.auth2.init({
                                client_id: '<?= Shop::$configuracion->google_api_id; ?>',
                                cookiepolicy: 'single_host_origin',
                                // Request scopes in addition to 'profile' and 'email'
                                //scope: 'additional_scope'
                            });
                            var element = document.getElementById('customBtn');
                            auth2.attachClickHandler(element, {},
                                    function (googleUser) {
                                        googleCartRegister(googleUser);
                                    }, function (error) {
                                //El usuario ha cancelado el login
                            });
                        });
                    });
                </script>
            </div>
            <!-- <div class="separado">ó</div> -->
            <h4><?=traducir('Cuenta de Facebook');?></h4>
            <div class="facebook">
                <a href="javascript:fb_login();" ><img  class="icono_red" src="<?=Theme::findFile('facebook.svg', false, true);?>" border="0" alt="<?= traducir('Identificarme con Facebook'); ?>"></a>
            </div>
		</div>

		<form action="<?=$url;?>" method="post" class="col-lg-6 col-md-6 col-sm-12 col-xs-12 registro_simple">
			<div class="account_creation">
				<fieldset>
					<h3 class="page-subheading"><?= traducir('Registrarte como nuevo usuario'); ?></h3>
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 campos">
						<h4><?= traducir('Datos personales'); ?></h4>
						<div class="required form-group">
							<input type="text" class="input_formulario form-control" name="nombre" value="<?=$datos_usuario['nombre_usuario'];?>" required="required" placeholder="<?=traducir('Nombre y apellidos');?>">
						</div>

						<div class="required form-group">
							<input type="email" class="input_formulario form-control" name="email" value="<?=$datos_usuario['email_usuario'];?>" required="required" placeholder="<?=traducir('Correo electrónico');?>" autocomplete="username">
						</div>

						<div class="required password form-group">
							<input type="password" class="input_formulario form-control" name="password" placeholder="<?= traducir('Contraseña'); ?>" required="required" autocomplete="new-password">
						</div>
						<div class="required password form-group">
							<input type="password" class="input_formulario form-control" name="password_repetido" placeholder="<?= traducir('Repetir contraseña'); ?>" required="required" autocomplete="new-password">
						</div>

					</div>
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 condiciones">
						<h4><?= traducir('Condiciones'); ?></h4>
						<div class="box_condiciones">
							<input type="checkbox" name="aceptar_condiciones" value="" required="required" id="id_aceptar_condiciones"/>
							<label for="id_aceptar_condiciones"><?= traducir("Acepto las condiciones de la"); ?> <a href="<?= Shop::$configuracion->url; ?>privacidad" title="<?= traducir("Política de privacidad "); ?>"><?= traducir("política de privacidad "); ?></a></label>
							<p><?= traducir('En conformidad con lo dispuesto en el Reglamento General de Protección de Datos 2016/679 autoriza expresamente a que sus datos de carácter personal sean tratados con la finalidad de prestarles los servicios comerciales solicitados. '); ?></p>
							<p><?= traducir('Los datos no seran cedidos a terceras partes, por lo que los destinatarios de esta información únicamente serán'); ?> <?= Shop::$empresa->nombre_legal; ?> <?= traducir('así como los profesionales o colaboradores internos y externos que prestan servicios a la misma. Los datos proporcionados se conservarán mientras se mantenga la relación o durante los años necesarios para cumplir con las obligaciones legales. Usted tiene el derecho a acceder a sus datos personales, rectificar los datos inexactos o solicitar su supresión cuando los datos ya no sean necesarios para los fines para los que fueron recogidos, así como cualesquiera derechos reconocidos en el RGPD 2016/679, en'); ?> <?= Shop::$empresa->direccion; ?>, <?= Shop::$empresa->cod_postal; ?>, <?= Shop::$empresa->localidad; ?> (<?= Shop::$empresa->provincia; ?>).</p>
						</div>
						<div class="pPubli">
							<p><?= traducir('Asimismo solicito su autorización para ofrecerle productos y servicios por cualquier medio (postal, email, teléfono) relacionados con los solicitados y fidelizarle como cliente.'); ?></p>
							<input name="pPupliSi" id='pPupliSi' type="checkbox" />	
							<label class="text-pPrivacidad" for="pPupliSi"><?=traducir('Si');?></label>
							<input name="pPupliNo" id='pPupliNo' type="checkbox"  />				
							<label class="text-pPrivacidad" for="pPupliNo"><?=traducir('No');?></label>
						</div>

						<?php
						//Añadimos al registro el captcha de google
						//new Widget("captcha");
						$grecatpcha = Module::Grecaptcha();
						echo($grecatpcha);
						?>
						<p class="mini_aclaracion"><?= traducir("Los campos marcados con asterisco ( * ) son obligatorios."); ?></p>
						<input type="hidden" name="accion[]" value="register registro">
						<div class="boton_registro">
							<button type="submit" name="enviar" value="" class="boton enviar_form_datos"><?= traducir('REGISTRARME'); ?></button>
						</div>
					</div>
				</fieldset>
			</div>
		</form>
	</div>
	<script>
	document.addEventListener('WSLE', function(event) {
		var pPupliSi = document.getElementById('pPupliSi');
		pPupliSi.addEventListener("change", validaCheckboxSi, false);

		function validaCheckboxSi() {
			var checked = pPupliSi.checked;
			if (checked) {
				document.getElementById('pPupliNo').disabled = true;
			} else {
				document.getElementById('pPupliNo').disabled = false;
			}
		}
		var pPupliNo = document.getElementById('pPupliNo');
		pPupliNo.addEventListener("change", validaCheckboxNo, false);

		function validaCheckboxNo() {
			var checked = pPupliNo.checked;
			if (checked) {
				document.getElementById('pPupliSi').disabled = true;
			} else {
				document.getElementById('pPupliSi').disabled = false;
			}
		}
	<?php
		//Según la variable del resultado, vamos a hacer focus en un sitio o en otro:
		if ($resultado_registro == -1){
	?>
			$('input[name="email"]').focus();
	<?php
		}
		if ( ($resultado_registro == -2) || ($resultado_registro == -3) ){
	?>
			$('input[name="password"]').focus();
	<?php
		}
	?>
	});
	</script>
<?php
}