/**
* 	17/11/2016
* 	Version 1.0
*	"clase" que nos permite tener cada uno de los selectores de un producto localizados.
*/
function selectorClass(soy, otros, padre, fichero){
	this.soy = soy;
	this.otros = otros;
	this.padre = padre;
	this.contenido;
	this.fichero = fichero;
	this.capa = $("#"+this.soy);
	this.ajax_url = shopUrl;
}
/**
*	Llamada asincrona  para obtener el html de la propiedad en cuestión
*/
selectorClass.prototype.llamadaAjax = function (objGlob,target){
	$.ajax({
		method: "POST",
		url: this.ajax_url+"comunes/consultas/generarExtraArticulo.php",
		data: JSON.stringify(objGlob),
		success: function (result) {
			//console.log(result);
			//Llamamos al colocar capa del selector afectado,  NO del actual
			//elementosTotales[target].colocarEnCapa(result);
			arraySelectores[target].colocarEnCapa(result);
		},
		error: function () {
			alert("La petición falló");
		},
		cache: false
	});
}
/**
*
*/
selectorClass.prototype.getHTMLcustom = function (contenido){
	for(key in this.otros){
		//Valor tiene el contenido en cuestion del array
		var valor = this.otros[key];
		var subobjeto = { "articulo_padre":this.padre};
		subobjeto[this.soy] = contenido
		var objetoGlobal ={
			"objeto": subobjeto,
			"campo_mostrar": valor,
			"ruta_fichero": this.fichero	
		};
		//console.log(JSON.stringify(objetoGlobal));
		this.llamadaAjax(objetoGlobal, valor);
	}
}
/**
* Coloca el html que llega de forma asincrona en la capa que le corresponde y además coloca el escuchador que necesita.
*/
selectorClass.prototype.colocarEnCapa = function(html){
	var seleccionado = this.capa.find(".selector option:selected").val();
	this.capa.html(html);
	var sel =  this.capa.find(".selector")[0];
	for(var i = 0; i < sel.length ; i++){
		//console.log(sel[i].value);
		if(sel[i].value === seleccionado){
			sel[i].selected = true;
			this.contenido = seleccionado;
		}
	}	
	this.setListener();
}
/**
*	El escuchador para los elementos select para que haga un change
*/
selectorClass.prototype.escuchadorChange = function(){
	var contenido = this.capa.find(".selector option:selected").val();
	this.contenido = contenido;
	this.getHTMLcustom(contenido);
}
/**
*	Escuchador para elementos con click
*/
selectorClass.prototype.escuchadorClick = function (){
	//De momento no hace nada
}
/**
*	Nos permite colocar a la capa propia el escuchador en cuestión
*/
selectorClass.prototype.setListener = function(){
	var objTmp = this;
	this.capa.find(".selector").change(function(event){
		objTmp.escuchadorChange();
	});
 }
//Creamos un array de elementos de forma global
var arraySelectores = [];