<?php

//---------------------------------------------------------------------------------
//	02/Octubre/2018 ==> Este fichero es el encargado de configurar las secciones
//  08/Octubre/2019 ==> Para ver si estamos en un error se lo preguntamos a las secciones
//
//---------------------------------------------------------------------------------
//Obtenemos la url
$real_url = 'http' . ((Shop::$configuracion->https_on) ? 's' : '') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
$url_base = Shop::$configuracion->url;
$url = str_replace($url_base, '', $real_url);
//Si no tenemos parámetros, creamos unos nuevos
Sections::checkParams();
//Vamos a quitar lo que haya después de la interrogación:
$interrogacion = strpos($url, '?');
if ($interrogacion !== false) {
    //Quitamos de la URL la interrogación y lo que hay a la derecha:
    $url = substr($url, 0, $interrogacion);
}

if (($url == '') || ($url == '/')) {
    //Estamos en el home:
    Sections::$current_section = 'home';
} else {
    //Hay que limpiar la url para quitar la / inicial y final si la tuviese:
    if (substr($url, 0, 1) == '/') {
        $url = substr($url, 1, strlen($url) - 1);
    }
    if (substr($url, -1) == '/') {
        $url = substr($url, 0, strlen($url) - 1);
    }

    //Vamos a componer la ruta:
    Sections::extractUrlPart($url);
    //Ahora tengo la ruta a la inversa, la invertimos en un nuevo array para tratarla
    $lista = Sections::$path;
    //Pedro 17/Octubre/2019 ==> Lo que  venga en la ruta hay que decodificarlo:
    foreach($lista as $key => $value){
        $lista[$key] = urldecode($value);
    }
    //Vamos a comprobar el idioma:
    $seccion_actual = $lista[0];
    //07/Octubre/2019
    //Ojo, vamos a tener en cuenta que es posible que nos estén pasando un idioma:
    if (strlen($seccion_actual) <= 3){
        //Vamos a intentar directamente cambiar el idioma:
        $idioma = Idioma::setCurrentLanguaje($seccion_actual);
        if ( (is_a($idioma, 'Idioma')) && ($idioma->codigo != '') ){
            //Si tenemos un idioma es porque el idioma está activo y se puede mostrar, en este caso, tenemos que quitarlo de la URL y continuar:
            //Nos acaban de pasar un idioma:
            //Ahora tenemos que quiar el idioma de la lista:
            $seccion_actual = 'home';
            array_shift($lista);
            if (count($lista) > 0){
                 $seccion_actual = $lista[0];
            }
        }
    }
 
    //Pedro 29/Mayo/2019 ==> OJO, Cuando sólo hay un elemento en la lista, puede que ya tenga paginación. Además inicializamos la sección siempre aquí
    if (count($lista) == 1) {   //Sólo es un elemento, eso quiere decir que ahí llevamos la sección actual y posíblemente la páginación:
        $valores = Sections::getValueAndPage($lista[0]);
        $seccion_actual = $valores[0];
    }
    Sections::$current_section = $seccion_actual;
    //Si la sección actual NO está vacía, Vamos a comprobar la sección:
    if ( (trim($seccion_actual) != '') && ($seccion_actual != 'home') ){    //Cuando estamos en el home o la sección está vacía, no seguimos 
        //Vamos ahora a analizar la sección en sí:
        $seccion_encontrada = false;

        //Según la lista, vamos a ver qué hacemos:
        switch ($seccion_actual) {
            case 'autor':
            case 'editorial':
            case 'fabricante':
            case 'marca':
            case 'coleccion':
            case 'nombre_coleccion':
                //Todos estos casos es un resultado búsqueda
                Sections::$current_section = 'resultado_busqueda';
                //Vamos a ver si hay pagina:
                $valor = '';
                $pagina = 0;
                //Me aseguro de haber recibido los valores correctos
                if (isset($lista[1])) {
                    $valores = Sections::getValueAndPage($lista[1]);
                    $valor = $valores[0];
                    $find = array(' ');
                    $repl = array('_');
                    $valor = str_replace($find, $repl, $valor);
                    $pagina = $valores[1];
                }
                //Componemos el parámetro que se ha buscado:
                Sections::setParam($seccion_actual, $valor);
                //Sections::$params->$seccion_actual = $valor;
                Sections::setParam('pagina', $pagina);
                //Sections::$params->pagina = $pagina;
                //Ahora es interesante extraer los filtrados:
                Sections::setParam('filtro', Sections::extactArrayFilter(array_slice($lista, 2)));
                //Sections::$params->filtro = Sections::extactArrayFilter(array_slice($lista, 2));
                $seccion_encontrada = true;
                break;
            case 'busqueda_avanzada':
                //Pedro 30/Mayo/2019 ==> Si hemos recibido algún valor de la búsqueda avanzada, componemos la URL y tiramos pa lante
                $campos_busqueda = array('nombre', 'subtitulo', 'autor', 'editorial', 'ean', 'nombre_coleccion');
                $contador = 0;
                $arrayBusqueda = array();
                $url = '';
                foreach ($campos_busqueda as $indice => $campo) {
                    $valor = Getter::get($campo, NULL);
                    $find = array(' ');
                    $repl = array('_');
                    $valor = str_replace($find, $repl, $valor);
                    if ($valor != NULL) {
                        $url .= '/' . $campo . '/' . $valor;
                    }
                }
                //Si tenemos URL, hacemos el redirect
                if ($url != '') {
                    Sesion::reloadPage(Shop::$configuracion->url . 'busqueda_avanzada' . $url);
                }
                //Llegados a este punto quiere decir que estamos ya con la URL compuesta:
                //Los parámetros han de ser pares, así que vamos a cogerlos de 2 en 2
                if (isset($lista[1])) {
                    Sections::$current_section = 'resultado_busqueda';
                    $parametros = array_slice($lista, 1);
                    //La url contiene un montón de parámetros y al final los filtros:
                    $estamosEnBusqueda = true;
                    for ($i = 0; ($i < count($parametros)) && ($estamosEnBusqueda); $i++) {
                        $campo_busqueda = $parametros[$i];
                        //Si estamos filtrando, aquí se termina todo:
                        if (strtoupper(substr($campo_busqueda, 7)) == 'FILTRAR') {
                            $estamosEnBusqueda = false;
                        } else {
                            $i++;
                            $valores = Sections::getValueAndPage($parametros[$i]);
                            Sections::setParam($campo_busqueda, $valores[0]);
                            Sections::setParam('pagina', $valores[1]);
                        }
                    }
                    //si quedan parámetros son de filtrados:
                    if ($i < count($parametros)) {
                        Sections::setParam('filtro', Sections::extactArrayFilter(array_slice($parametros, $i)));
                    }
                } else {
                    //Asignamos la sección
                    Sections::$current_section = 'busqueda_avanzada';
                }
                //Indicamos que se ha encontrado seccion
                $seccion_encontrada = true;
                break;
            case 'buscar':
                //Vamos a determinar si se acaba de hacer submit en el formulario o estamos en la búsqueda ya normal:
                $texto_busqueda = Getter::get('txt_busqueda', NULL);
                $find = array(' ');
                $repl = array('_');
                $texto_busqueda = str_replace($find, $repl, $texto_busqueda);
                if ($texto_busqueda != NULL) {
                    Sesion::reloadPage(Shop::$configuracion->url . 'buscar/' . $texto_busqueda);
                }
                //Si seguimos por aquí es por que no ha habido redireccion

                //Asignamos la sección
                Sections::$current_section = 'resultado_busqueda';
                $valor = '';
                $pagina = 0;
                //Me aseguro de haber recibido los valores correctos
                if (isset($lista[1])) {
                    //Vamos a ver si hay pagina:
                    $valores = Sections::getValueAndPage($lista[1]);
                    $valor = $valores[0];
                    $pagina = $valores[1];
                }
                //En "valor" tengo el texto que el usuario ha buscado. Hay que quitar aquí el guión bajo:
                $find = array('_');
                $repl = array(' ');
                $valor = str_replace($find, $repl, $valor);
                /*echo("<!--");
                var_dump($valor);
                echo("-->");*/
                Sections::setParam('txt_busqueda', $valor);
                //Sections::$params->txt_busqueda = $valor;
                Sections::setParam('pagina', $pagina);
                //Sections::$params->pagina = $pagina;
                //Ahora es interesante extraer los filtrados:
                Sections::setParam('filtro', Sections::extactArrayFilter(array_slice($lista, 2)));
                //Sections::$params->filtro = Sections::extactArrayFilter(array_slice($lista, 2));
                //indicamos que se ha encontrado
                $seccion_encontrada = true;
                break;

            case 'registro':
                //Asignamos la sección e indicamos que se ha encontrado
                //Sections::$current_section = 'registro';
                //Asignamos los parametros
                Sections::setParam('emailUsuario', Getter::get('emailUsuario', ''));
                $seccion_encontrada = true;
                break;

            case 'confirmacion_registro':
                //Asignamos la sección e indicamos que se ha encontrado
                Sections::$current_section = 'confirmacion_registro';
                //Asignamos los parametros
                Sections::setParam('codigo_confirmacion', $lista[1]);
                //Sections::$params->codigo_confirmacion = $lista[1];
                Sections::setParam('codigo_cliente', $lista[2]);
                //Sections::$params->codigo_cliente = $lista[2];
                //indicamos que se ha encontrado
                $seccion_encontrada = true;
                break;

            /* case 'datos_compra':
              //Asignamos la sección
              Sections::$current_section = 'cesta';
              //Asignamos los valores
              Sections::setParam('paso_cesta', 1);
              //Sections::$params->paso_cesta = 1;
              $seccion_encontrada = true;
              break; */
            /* case 'tipo_envio':
              //Asignamos la sección
              Sections::$current_section = 'cesta';
              //Asignamos los valores
              Sections::setParam('paso_cesta', 2);
              //Sections::$params->paso_cesta = 2;
              $seccion_encontrada = true;
              break; */
            /* case 'forma_pago':
              //Asignamos la sección
              Sections::$current_section = 'cesta';
              //Asignamos los valores
              Sections::setParam('paso_cesta', 3);
              //Sections::$params->paso_cesta = 3;
              $seccion_encontrada = true;
              break;
              case 'resumen_compra':
              //Asignamos la sección
              Sections::$current_section = 'cesta';
              //Asignamos los valores
              Sections::setParam('paso_cesta', 4);
              //Sections::$params->paso_cesta = 4;
              $seccion_encontrada = true;
              break;
              case 'finalizar_compra':
              //Asignamos la sección
              Sections::$current_section = 'finalizar_compra';
              //A día de hoy no tenemos código de pedido, la propia sección actualizará el pedido
              $seccion_encontrada = true;
              break;
             */

            case 'finalizar_compra':
                //Asignamos la sección
                Sections::$current_section = 'finalizar_compra';
                if (isset($lista[1])) {
                    Sections::setParam('numero_pedido', $lista[1] . "\n");
                }
                //A día de hoy no tenemos código de pedido, la propia sección actualizará el pedido
                $seccion_encontrada = true;
                break;
            case 'historico_pedidos':
                //Todos estos casos es un resultado búsqueda
                //Sections::$current_section = 'pedidos_pendientes';
                //Vamos a ver si hay pagina:
                $pagina = 0;
                //Me aseguro de haber recibido los valores correctos
                if (isset($lista[0])) {
                    $valores = Sections::getValueAndPage($lista[0]);
                    $pagina = $valores[1];
                }
                Sections::setParam('pagina', $pagina);
                //Sections::$params->pagina = $pagina;
                $seccion_encontrada = true;
                break;

            case 'cursos':
                //Asignamos la sección
                //Sections::$current_section = 'cursos';
                //Asignamos los valores
                Sections::setParam('colegio', $lista[1]);
                //Sections::$params->colegio = $lista[1];
                $seccion_encontrada = true;
                break;
            case 'lote':
                //Asignamos la sección
                //Sections::$current_section = 'lote';
                //Asignamos los valores
                Sections::setParam('nombre_lote', $lista[1]);
                //Sections::$params->nombre_lote = $lista[1];
                $seccion_encontrada = true;
                break;
            case 'venta_lote':
                //Asignamos la sección
                //Sections::$current_section = 'venta_lote';
                //Asignamos los valores
                Sections::setParam('nombre_colegio', $lista[1]);
                //Pedro 03/Septiembre/2020 ==> Es posible que el nombre del lote no tenga colegio/curso y sea un nombre como tal
                if (isset($lista[2])){
                    Sections::setParam('nombre_curso', $lista[2]);
                }
                //Sections::$params->nombre_lote = $lista[1];
                $seccion_encontrada = true;
                break;
            case 'busqueda_lote':
                //Asignamos la sección
                Sections::$current_section = 'resultado_busqueda_lote';
                //Asignamos los valores
                Sections::setParam('lote_buscar', $lista[1]);
                //Sections::$params->lote_buscar = $lista[1];
                $seccion_encontrada = true;
                break;

            case 'deposito':
                //Asignamos la sección
                //Sections::$current_section = 'deposito';
                //Asignamos los valores
                Sections::setParam('codigo_deposito', $lista[1]);
                //Sections::$params->codigo_deposito = $lista[1];
                $seccion_encontrada = true;
                break;

            case 'depositos':
                //Todos estos casos es un resultado búsqueda
                //Sections::$current_section = 'depositos';
                //Vamos a ver si hay pagina:
                $pagina = 0;
                //Me aseguro de haber recibido los valores correctos
                if (isset($lista[1])) {
                    $pagina = $valores[1];
                }
                Sections::setParam('pagina', $pagina);
                //Sections::$params->pagina = $pagina;
                $seccion_encontrada = true;
                break;

            case 'factura':
                //Asignamos la sección
                //Sections::$current_section = 'factura';
                //Asignamos los valores
                Sections::setParam('factura', $lista[1]);
                //Sections::$params->factura = $lista[1];
                $seccion_encontrada = true;
                break;

            case 'facturas':
                //Todos estos casos es un resultado búsqueda
                //Sections::$current_section = 'facturas';
                //Vamos a ver si hay pagina:
                $pagina = 0;
                //Me aseguro de haber recibido los valores correctos
                if (isset($lista[1])) {
                    $pagina = $valores[1];
                }
                Sections::setParam('pagina', $pagina);
                //Sections::$params->pagina = $pagina;
                $seccion_encontrada = true;
                break;

            case 'descargar-adjunto':
                //Asignamos la sección e indicamos que se ha encontrado
                //Sections::$current_section = 'fichero_adjunto';
                Sections::setParam('ruta', $lista[1]);
                //Sections::$params->ruta = $lista[1];
                $seccion_encontrada = true;
                break;
            case 'conocenos':
                //Asignamos la sección
                //Sections::$current_section = 'conocenos';
                //Asignamos los valores
                $seccion_encontrada = true;
                break;
        }

        //Si no hemos encontrado la sección vamos a ver qué hacemos 
        if (!$seccion_encontrada) {
            //Antes empezábamos por un escaparate. Ahora empezamos por artículo, una forma de verlo es pensar que en "lista" tengo dos valores
            if (count($lista) == 2) {
                //Le vamos a dar prioridad a los productos:
                //Vamos a ver si el último elemento es un EAN
                $ultimoElemento = $lista[count($lista) - 1];

                //Vamos a ver si era un artículo pero cogiéndolo del "último elemento":
                $ean = Sections::preg_replace_callback_array(
                                [
                            '#(.+)\-p(.+)#' => function (&$matches) { //Modificado por Pedro el 25/Febrero/2019 ==> los artículos tienen SIEMPRE una barra separando categoría de nombre de producto
                                return($matches[2]);
                            },
                                ], $ultimoElemento
                );

                //Si tenemos un ean, vamos a cargar el producto:
                if ($ean != $ultimoElemento) {
                    $articulo = new Articulo($ean);
                    if ($articulo->codigo > 0) {
                        //Establecemos el seo:
                        $articulo->setSEO();
                        //Eureka, estamos en un producto
                        Sections::$current_section = 'ficha';
                        Sections::setParam('articulo', $articulo);
                        //Sections::$params->articulo = $articulo;
                        //var_dump($articulo);
                        $seccion_encontrada = true;
                    }
                }
            }
        }
        
        //en valor tengo el nombre del posible escaparate a cargar:
        if (!$seccion_encontrada) {
            //Lo suyo es empeza cargando un escaparate con el último valor de la ruta:
            $infoEscaparate = (isset($lista[0])) ? $lista[0] : '';
            $valores = Sections::getValueAndPage($infoEscaparate);
            $valor = $valores[0];
            $pagina = $valores[1];
            //Ahora es interesante extraer los filtrados TODO:
            $filtro = Sections::extactArrayFilter(array_slice($lista, 1));
            if ( (!is_numeric($valor)) && (trim($valor) != '') ) {
                //Si aquí tuviese un valor no numérico estoy en un producto o escaparate (por ahora)
                //Escaparate, limpiamos el nombre para meter los comodines:
                $nombre_escaparate = rawurldecode(mb_strtolower($valor));
                $find = array('-');
                $repl = array('_');
                $nombre_escaparate = str_replace($find, $repl, $nombre_escaparate);
                $opciones = new OpcionesWidget(array(
                    'codigo' => $nombre_escaparate,
                    'filtrado_actual' => $filtro
                ));
                //var_dump($opciones);
                $escaparate = new Escaparate($opciones);
                
                if ($escaparate->codigo > 0) {
                    //Establecemos el SEO
                    $escaparate->setSEO();
                    //Hay que cargar los productos del escaparate y crear los objetos "artículo" según esta lista
                    $escaparate->carga_articulos($pagina, 0); // ==> Se pone un 0 para que se respete la paginación, si no se pone nada se cargan todos
                    //Eureka, estamos en un escaparate
                    Sections::$current_section = 'escaparate';
                    Sections::setParam('escaparate', $escaparate);
                    //Sections::$params->escaparate = $escaparate;
                    Sections::setParam('pagina', $pagina);
                    //Sections::$params->pagina = $pagina;
                    //Sections::setParam('filtro', $filtro);
                    $seccion_encontrada = true;
                }
                
            }
        }
        //Llegados a este punto, si no hay sección estamos en un error:
        if (!Sections::sectionExists(Sections::$current_section)){
            Sections::$current_section = 'error';
        }
        
    }else{
        //La sección está vacía, estamos en el home
        Sections::$current_section = 'home';
    }
}

//Otra cosa que vamos a hacer es que no exista la capa de "restaurar" de la cesta cuando cambiemos de sección:
Sesion::remove('lastDeleted');
