<?php
//---------------------------------------------------------------------------------------------------------
// 3/diciembre/2015
// Versión 1.0 Fichero para mostrar la descarga del fichero csv de la factura
//---------------------------------------------------------------------------------------------------------

if ($numero_fichero != NULL) {
    $factura = new Factura($numero_fichero, true, true, true, true);
    if ($factura->codigo > 0) {
        header("Content-Type: text/csv; charset=ISO-8859-1");
        header("Content-Disposition: attachment; filename=factu$numero_fichero.csv");
        /* Registro Shop:: */
        $cliente = $factura->cliente;
        $fe = "E;";
        $fe .="Shop::$empresa->nombre_legal;"; //Nombre legal
        $fe .="Shop::$empresa->nombre";   //Nombre Comercial
        $fe .="Shop::$empresa->cif;"; //CIF
        $fe .="Shop::$empresa->direccion;"; //direccion
        $fe .="Shop::$empresa->cod_postal;";  //codPOST
        $fe .="Shop::$empresa->localidad;";  //localidad
        $fe .="Shop::$empresa->provincia;";   //provincia
        $fe .="Shop::$empresa->telefono_Shop::;";  //Numero Telefono
        /* Registro de Cliente */
        $rC = "C;";     //Tipo de registro
        $rC .="$cliente->nombre_legal;"; //Nombre legal
        $rC .="$cliente->nombre_comercial";   //Nombre Comercial
        $rC .="$cliente->cif;"; //CIF
        $rC .="$cliente->direccion;"; //direccion
        $rC .="$cliente->cod_postal;";  //codPOST
        $rC .="$cliente->localidad;";  //localidad
        $rC .="$cliente->provincia;";   //provincia
        $rC .="$cliente->telefono;";  //Numero Telefono
        /* Identificacion de factura */
        $f = "F;";
        $f .= "$factura->num_doc;";
        $f .= date_format($factura->fecha_date_format, "Ymd");
        $f .= "$factura->tipo_doc_nombre;";

        /* Registro de lineas */
        $rL ="";
        foreach ($factura->albaranes as $key => $albaran) {
            $rL .= "A;"; //Tipo de registro
            $rL .= $albaran->num_doc . ";"; //Numero de albaran
            $rL .= date_format($albaran->fecha_date_format, "Ymd") . ";"; //Fecha
            $rL .= $albaran->nombre_tipo_doc . ";";
            $rL .= "\r\n";
            foreach ($albaran->lineas_albaran as $key => $linea) {
                $rL .= "L;"; //Tipo de registro
                $rL .= $linea->ean . ";"; //EAN
                $rL .= $linea->objeto_articulo->nombre . ";"; //nombre
                $rL .= "$linea->cantidad;"; //cantidad
                $rL .= "$linea->importe;"; // pvp
                $rL .= "$linea->iva;"; //iva
                $rL .= $linea->importe . ";"; // precio sin iva
                $rL .= $linea->descuento . ";"; // dto
                $rL .= $linea->objeto_articulo->base; // precio unidad
                $rL .= $linea->importe . ";"; // importe
                $rL .="\r\n";
            }
            for ($i = 1; $i <= 4; $i++) {
            $iva = "iva$i";
            $base = "base$i";
            $imp_iva = "imp_iva$i";
            $recargo = "imp_recargo$i";
            $bruto = "bruto$i";
            $rL .=  ($albaran->$iva) != 0 ? $albaran->$iva . ";" : " ;";
            $rL .=  ($albaran->$base) != 0 ? $albaran->$base . ";" : " ;";
            $rL .=  ($albaran->$imp_iva) != 0 ? $albaran->$imp_iva . ";" : " ;";
            $rL .=  ($albaran->$recargo) != 0 ? $albaran->$recargo : " ;";
            $rL .=  ($albaran->$bruto) != 0 ? $albaran->$bruto . ";" : " ;";
        }
            $rL .= ($albaran->total_albaran * 100) . ";"; //Importe
        }

        /* Mostramos el contenido */
        echo $fe . "\r\n";
        echo $rC . "\r\n";
        echo $f . "\r\n";
        echo $rL;
        /* Pie Factura */
        for ($i = 1; $i <= 4; $i++) {
            $iva = "iva$i";
            $base = "base$i";
            $imp_iva = "imp_iva$i";
            $recargo = "imp_recargo$i";
            $bruto = "bruto$i";
            echo ($factura->$iva) != 0 ? $factura->$iva . ";" : " ;";
            echo ($factura->$base) != 0 ? $factura->$base . ";" : " ;";
            echo ($factura->$imp_iva) != 0 ? $factura->$imp_iva . ";" : " ;";
            echo ($factura->$recargo) != 0 ? $factura->$recargo : " ;";
            echo ($factura->$bruto) != 0 ? $factura->$bruto . ";" : " ;";
        }
    } else {
        ?>
                <p class="error_sinli">////<?= traducir("No se ha podido cargar la factura"); ?></p>
        <?php
    }
}
?>