<?php
//---------------------------------------------------------------------------------------------------------
// 10/Octubre/2014
// Versión 1.0 Versión estándar del código html de una mini-ficha de artículo
//---------------------------------------------------------------------------------------------------------
// Versión 1.1 No se va a utilizar "articulo_a_mostrar" en su lugar usaremos una variable local llamada "articulo_a_mostrar"
//---------------------------------------------------------------------------------------------------------
// Versión 1.2 A partir de ahora se cargan los tamaños de las portadas de la tabla "tam_portadas"
// Y la imagen se muestra con "capa_imagen
//---------------------------------------------------------------------------------------------------------
/* Preparacion de los enlaces para las redes sociales de forma que no necesitemos los plugin oficiales */
$url = "https://" . $_SERVER['HTTP_HOST'] . ":" . $_SERVER['SERVER_PORT'] . $_SERVER['REQUEST_URI'];
$url_facebook = "http://facebook.com/sharer.php?u=" . urlencode($url);
$urltwitter = "http://twitter.com/home?status=" . urlencode($url);
$urlgoogle = "https://plus.google.com/share?url=" . urlencode($url) . '&media=http://www.sinlib.es/portadasSinlib/muestraFoto.php?ean=' . $articulo_a_mostrar->ean . '&ancho=300&alto=300&calidad=100&fichero_no_foto=arminet.jpg';
$urlwasap = "whatsapp://send?text=" . urlencode($url) . '&media=http://www.sinlib.es/portadasSinlib/muestraFoto.php?ean=' . $articulo_a_mostrar->ean . '&ancho=300&alto=300&calidad=100&fichero_no_foto=arminet.jpg';
$urlpinterest = 'http://pinterest.com/pin/create/button/?url=' . urlencode($url) . '&media=http://www.sinlib.es/portadasSinlib/muestraFoto.php?ean=' . $articulo_a_mostrar->ean . '&ancho=300&alto=300&calidad=100&fichero_no_foto=arminet.jpg';
$product = $articulo_a_mostrar;

?>
<div class="<?= Theme::getConfigParam('container_style', 'container'); ?>">
    <?php
    escupirMiga('prd', true, ">"); //El segundo valor indica que quiero una miga compuesta por el servidor
    ?>
</div>
<div id="columns" class="<?= Theme::getConfigParam('container_style', 'container'); ?>">
    <?php
    // Pedro 30/Julio/2020
    //Voy a mantener el ID de esta columna por simple retrocompatibilidad, en los css básicos de la plantilla lo he quitado:
    ?>
    <div id='left_column2' class='aside_top column col-xs-12 col-sm-12 col-md-4 col-lg-3'>
        <?php
        $fichero_aside = 'aside_top';
        $ruta_aside = Theme::include_file($fichero_aside . '.php');
        ?>
    </div>
    <div class="bloque_ficha col-xs-12 col-sm-12 col-md-8 col-lg-9">
        <div class="primary_block">

            <div class="pb-left-column col-xs-12 col-sm-6 col-md-4">
                <div id="image-block" class="clearfix">

                    <?php

                    //Debemos de poner el código de cliente de Hedra
                    $opciones = new OpcionesWidget(array("ean" => $product->ean, "cliente" => Shop::$configuracion->cliente_arminet, "ruta_base" => "https://sinlib.es/"));
                    new Widget($_WH->GW("multifoto", "mostrarPortadaMultiFotoLupita"), $opciones);
                    ?>
                </div>
                <div class="datos_extra">
                    <span class="title_datos"><?= traducir('DATOS'); ?></span>
                    <div class="box-datos">
                        <div class="ean">
                            <span class="titulo"><?= traducir('EAN'); ?>: </span>
                            <span><?= $product->ean ?></span>
                        </div>

                        <?php
                        if ($product->editorial != '') {
                        ?>
                            <div class="even">
                                <span class="titulo"><?= ($product->tipo == "L") ? traducir('Editorial') : traducir('Fabricante'); ?>: </span>
                                <span><a href="<?= corregir_url(Shop::$configuracion->url . "editorial/" . $product->editorial); ?>" title="<?= $product->editorial ?>"><?= $product->editorial ?></a></span>
                            </div>
                        <?php
                        }

                        if ($product->num_paginas > 0) {
                        ?>
                            <div class="even">
                                <span class="titulo"><?= traducir('Páginas'); ?>: </span>
                                <span><?= $product->num_paginas ?></span>
                            </div>
                        <?php
                        }

                        if ($product->ilustrador != '') {
                        ?>
                            <div class="even">
                                <span class="titulo"><?= traducir('Ilustrador'); ?>: </span>
                                <span><?= $product->ilustrador ?></span>
                            </div>
                        <?php
                        }

                        if ($product->coleccion != '') {
                        ?>
                            <div class="even">
                                <span class="titulo"><?= traducir('Colección'); ?>: </span>
                                <span><?= $product->coleccion ?></span>
                            </div>
                        <?php
                        }

                        if ($product->encuadernacion != '') {
                        ?>
                            <div class="even">
                                <span class="titulo"><?= traducir('Encuadernación'); ?>: </span>
                                <span><?= $product->encuadernacion ?></span>
                            </div>
                        <?php
                        }

                        if ($product->alto > 0 && $product->ancho) {
                        ?>
                            <div class="even">
                                <span class="titulo"><?= traducir('Tamaño'); ?>: </span>
                                <span><?= $product->ancho ?>mm X <?= $product->alto ?>mm</span>
                            </div>
                        <?php
                        }

                        if ($product->peso > 0) {
                        ?>
                            <div class="even">
                                <span class="titulo"><?= traducir('Peso'); ?>: </span>
                                <span><?= $product->peso ?> gr</span>
                            </div>
                        <?php
                        }
                        ?>

                    </div>
                </div>
                <div class="contenedor_redes">
                    <p class="socialsharing_product no-print">
                        <a class="solcial facebook boton" href="<?= $url_facebook ?>" target="_blank">
                            <i class="mdi mdi-facebook"></i>
                        </a>
                        <a class="solcial twitter boton" href="<?= $urltwitter ?>" target="_blank">
                            <i class="mdi mdi-twitter"></i>
                        </a>
                        <a class="solcial pinterest boton " href="<?= $urlpinterest ?>" target="_blank">
                            <i class="mdi mdi-pinterest"></i>
                        </a>
                        <a class="solcial wasap boton" href="<?= $urlwasap ?>" target="_blank">

                            <i class="mdi mdi-whatsapp"></i>
                        </a>
                    </p>
                </div>
            </div>

            <div class="pb-center-column col-xs-12 col-sm-6 col-md-8">
                <h2 itemprop="name"><?= $product->nombre; ?></h2>
                <div class="box-info-product col-xs-12">
                    <?php
                    if ($product->autor != '') {
                    ?>
                        <div class="odd">
                            <span class="titulo"><?= traducir('Autor') ?></span>
                            <span><a href="<?= corregir_url(Shop::$configuracion->url . "autor/" . $product->autor); ?>" title="<?= $product->autor ?>"><?= $product->autor ?></a></span>
                        </div>
                    <?php
                    }

                    ?>

                </div>
                <div class="box-precio col-xs-12">
                    <div class="stock">
                        <?php
                        if ($articulo_a_mostrar->stock <= 0) {
                        ?>
                            <p class="no_disponible"><?= traducir('Artículo no disponible'); ?></p>
                        <?php
                        } else if ($articulo_a_mostrar->stock == 1) {
                        ?>
                            <p class="pocos_articulos"><?= traducir('Quedan pocos artículos'); ?></p>
                        <?php
                        } else {
                        ?>
                            <p class="disponible"><?= traducir('Artículo disponible'); ?></p>
                        <?php
                        }
                        ?>
                    </div>
                    <div id="priceAndBuy" class="no-print">
                        <?php
                        if ($product->pvp_final != $product->pvp) {
                        ?>
                            <p id="old_price" class="">
                                <span id="old_price_display">
                                    <span class="price"><?= number_format($product->pvp, Shop::$configuracion->decimales, ",", "."); ?> &euro;</span>
                                </span>
                            </p>
                            <p class="our_price_display">
                                <span id="our_price_display" class="price"><?= number_format($product->pvp_final, Shop::$configuracion->decimales, ",", "."); ?> &euro; </span>
                            </p>
                        <?php
                        } else {
                        ?>
                            <p class="our_price_display">
                                <span id="our_price_display" class="price"><?= number_format($product->pvp_final, Shop::$configuracion->decimales, ",", "."); ?> &euro;</span>
                            </p>
                        <?php
                        }
                        ?>
                        <div class="box-cart-bottom">
                            <?php
                            //Boton comprar
                            $conf = new OpcionesWidget(array(
                                'articulo' => $product,
                                'fichero_boton' => 'botonComprarAmpliadaTecnica',
                                'cantidad_dinamica' => true,
                                'addBtnCantidad' => true
                            ));
                            new Widget($_WH->GW("articulo", "btnComprar"), $conf);
                            ?>
                        </div>
                    </div>
                </div>

                <div id="ancla" class="info_total">
                    <?php
                    if ($product->observaciones != '') {
                    ?>
                        <div class="box-description">
                            <p><?= $product->observaciones; ?></p>
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </div>

        </div>
        <?php
        //Cargamos 3 productos relacionados con éste
        $relacionados = $product->productos_relacionados();
        if ($relacionados > 0) {
        ?>
            <div id="productos_relacionados">
                <h4 class="headRelated"><?= traducir('Productos Relacionados'); ?>:</h4>
                <?php
                $widget_relacionados = new Widget($_WH->GW('articulo', 'lista_articulos'), 'mini_ficha_semaforo', $product->lista_articulos);
                ?>
            </div>
        <?php
        }
        $articulo_a_mostrar->cleanListaArticulos();
        $articulo_a_mostrar->relacionados_x_autor(4);
        if (count($articulo_a_mostrar->lista_articulos) > 0) {
        ?>
            <div id="productos_relacionados" class=" col-lg-12">
                <h4 class="title_block"><?= traducir('Del mismo autor'); ?>:</h4>
                <?php
                //TODO mostrar articulos relacionados del mismo autor
                $widget_relacionados = new Widget($_WH->GW('articulo', 'lista_articulos'), 'mini_ficha_datos_hover', $articulo_a_mostrar->lista_articulos);
                ?>
            </div>
        <?php
        }
        ?>
    </div>

    <div id='left_column1' class='aside_bottom column col-xs-12 col-sm-12 col-md-4 col-lg-3'>
        <?php
        $fichero_aside = 'aside_bottom';
        $ruta_aside = Theme::include_file($fichero_aside . '.php');
        ?>
    </div>
</div>

<!--Datos para google shoping-->
<span itemprop="name" content="<?= $product->nombre; ?>"></span>
<span itemprop="offerURL" content="<?= $product->url; ?>"></span>
<span itemprop="image" content="<?= Shop::$configuracion->url; ?>portada/600/600/<?= $product->ean; ?>.jpg"></span>
<span itemprop="offerDetails" itemscope itemtype="http://data-vocabulary.org/Offer">
    <span itemprop="identifier" content="isbn:<?= $product->ean; ?>"></span>
    <span class="precio-producto">
        <span itemprop="price" content="<?= number_format($product->pvp, Shop::$configuracion->decimales, ",", "."); ?>"></span>
        <span itemprop="currency" content="EUR"></span>
    </span>
    <?php
    if ($product->stock > 0) {
        $disponibilidad = "in_stock";
    } else {
        $disponibilidad = "out_of_stock";
    }
    ?>
    <span itemprop="availability" content="<?= $disponibilidad; ?>"></span>
</span>
<?php
$product->observaciones = str_replace('<br>', '\\n', $product->observaciones);
?>
<!-- Datos para Facebook -->
<meta property="og:title" content="<?= $product->nombre; ?>">
<meta property="og:type" content="article">
<meta property="og:description" content='<?= $product->observaciones; ?>'>
<meta property="og:url" content="<?= $product->url; ?>">
<meta property="og:image" content="<?= Shop::$configuracion->url; ?>portada/600/600/<?= $product->ean; ?>.jpg">
<meta property="og:site_name" content="<?= Shop::$configuracion->url; ?>">